const ADMINEDITORBRXC = {
    vueState: document.querySelector('.brx-body').__vue_app__.config.globalProperties.$_state,
    helpers: {
        isElementActive: function(){
            if(ADMINEDITORBRXC.vueState.activePanel !== "element" || !typeof ADMINEDITORBRXC.vueState.activeElement === "object") return false;
            return true;
         },
    },
    appendElements: function(){
        const els = document.querySelector('#bricks-panel-inner #bricks-panel-elements');
        const defaultPanel = document.querySelector('#bricks-panel-inner #default-panel')

        if(!els || defaultPanel) return;

        els.innerHTML = '<div id="default-panel" class="no-results"><p>No element selected. Hover the page and click on an selectable element (with a blue outline) to modify the content.</p><a href="https://academy.bricksbuilder.io/article/builder-intro/" target="_blank" class="button">Learn more</a></div>';
    },
    limitPanelVisibility: function(){
        const self = this;
        const panel = document.querySelector('#bricks-panel');
        setTimeout(() => {
            if(!self.helpers.isElementActive()){
                panel.classList.remove('visible');
                return;
            }
            const activeEl = self.vueState.activeElement;
            console.log(activeEl)
    
            if(self.limitPanelVisibilityArr.includes(activeEl.name)){
                panel.classList.add('visible');
            } else {
                panel.classList.remove('visible');
            }
        }, 10)

    },
    runStateFunctions: function(){
        const self = this;
        self.appendElements();
        self.limitPanelVisibility();
    },
    runObserver: function() {
        const self = this;
        const panelInner = document.querySelector('#bricks-panel');
        if (!panelInner) return;

        const observer = new MutationObserver(function(mutations) {
            if(self.vueState.brxcRunningObserver === true) return;
            self.vueState.brxcRunningObserver = true;
            self.runStateFunctions();
            
            setTimeout(() => self.vueState.brxcRunningObserver = false, 300)
        });
        observer.observe(panelInner, { subtree: true, childList: true });
    },
    initObservers: function(){
        const self = this;
        self.runObserver();
    },
    init: function(){
        const self = this;
        self.initObservers();
        self.appendElements();
    }
}


window.addEventListener('load', () => {
    setTimeout(ADMINEDITORBRXC.init(), 300);
})

