<?php
namespace Advanced_Themer_Bricks;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class AT__Init {
    public static function init_hooks() {
        
        /*--------------------------------------
        Plugin Page
        --------------------------------------*/
        
        add_filter( 'plugin_action_links_bricks-advanced-themer/bricks-advanced-themer.php', 'Advanced_Themer_Bricks\AT__Admin::add_plugin_links' );
        
        /*--------------------------------------
        Add ACF PRO
        --------------------------------------*/

        global $brxc_acf_already_exists;
        if($brxc_acf_already_exists === false){
            add_action( 'init', 'Advanced_Themer_Bricks\AT__ACF::remove_acf_menu');
        }
        add_action( 'admin_init', 'Advanced_Themer_Bricks\AT__ACF::acf_get_role');
        add_action( 'acf/init', 'Advanced_Themer_Bricks\AT__ACF::acf_color_palettes_fields');
        add_action( 'acf/init', 'Advanced_Themer_Bricks\AT__ACF::acf_settings_fields');
        
        /*--------------------------------------
        EDD Updated
        --------------------------------------*/
        
        add_action( 'init', 'Advanced_Themer_Bricks\AT__License::brxc_plugin_updater' );
        add_action( 'admin_init', 'Advanced_Themer_Bricks\AT__License::brxc_register_option' );
        add_action( 'admin_init', 'Advanced_Themer_Bricks\AT__License::brxc_activate_license' );
        add_action( 'admin_init', 'Advanced_Themer_Bricks\AT__License::brxc_deactivate_license' );
        add_action( 'admin_notices', 'Advanced_Themer_Bricks\AT__License::brxc_admin_notices' );
        
        /*--------------------------------------
        Option Page Menu
        --------------------------------------*/
        add_action( 'acf/init', 'Advanced_Themer_Bricks\AT__ACF::create_advanced_themer_option_page');
        add_action( 'admin_menu', 'Advanced_Themer_Bricks\AT__License::brxc_license_menu',9999);
        
        /*--------------------------------------
        Menu
        --------------------------------------*/

        add_filter( 'admin_menu', 'Advanced_Themer_Bricks\AT__Admin::remove_theme_settings_from_bricks_menu', 999);

        /*--------------------------------------
        Variables
        --------------------------------------*/

        add_action( 'init', 'Advanced_Themer_Bricks\AT__Global_Colors::convert_color_palette_options', 35);
        add_action( 'init', 'Advanced_Themer_Bricks\AT__ACF::load_global_acf_variable', 2 );

        // To be checked
        add_action( 'save_post', 'Advanced_Themer_Bricks\AT__ACF::save_inline_css_in_db', 40);
        add_action( 'trashed_post', 'Advanced_Themer_Bricks\AT__ACF::save_inline_css_in_db', 40);
        add_action( 'transition_post_status', 'Advanced_Themer_Bricks\AT__ACF::save_inline_css_in_db', 40, 9999);
        add_action( 'shutdown', 'Advanced_Themer_Bricks\AT__ACF::save_inline_css_in_db');

        add_action( 'init', 'Advanced_Themer_Bricks\AT__Global_Colors::load_global_color_variable' );
        

        /*--------------------------------------
        Create Color Palette CPT 
        --------------------------------------*/

        add_action( 'init', 'Advanced_Themer_Bricks\AT__Admin::color_palette_cpt_init', 2 , 10 );
        
        /*--------------------------------------
        Load Custom data in ACF fields
        --------------------------------------*/
        add_filter( 'acf/load_field/key=field_6388e73289b6a', 'Advanced_Themer_Bricks\AT__ACF::load_user_roles_inside_select_field');
        add_filter( 'acf/load_field/key=field_63899284664e9', 'Advanced_Themer_Bricks\AT__ACF::load_post_types_inside_select_field' );
        add_filter( 'acf/load_value/key=field_63a6a51731bbb', 'Advanced_Themer_Bricks\AT__ACF::load_spacing_default_repeater_values', 10, 3);
        add_filter( 'acf/load_value/key=field_63c8f17f5e2ed', 'Advanced_Themer_Bricks\AT__ACF::load_border_default_repeater_values', 10, 3);
        add_filter( 'acf/load_value/key=field_63a6a58831bbe', 'Advanced_Themer_Bricks\AT__ACF::load_typography_default_repeater_values', 10, 3);
        add_filter( 'acf/load_value/key=field_63b48c6f1b20a', 'Advanced_Themer_Bricks\AT__ACF::load_grid_default_repeater_values', 10, 3);
        add_filter( 'acf/load_value/key=field_63882c3ffbgc1', 'Advanced_Themer_Bricks\AT__ACF::load_human_readable_text_value', 10, 3);
        add_filter( 'acf/load_value/key=field_64018efb660fb', 'Advanced_Themer_Bricks\AT__ACF::load_openai_password', 10, 3);
        add_action( 'acf/save_post', 'Advanced_Themer_Bricks\AT__ACF::save_openai_password', 5, 1 );
        add_action( 'acf/fields/flexible_content/no_value_message', 'Advanced_Themer_Bricks\AT__ACF::change_flexible_layout_no_value_msg', 10, 3);

        
        /*--------------------------------------
        Register / Enqueue Styles
        --------------------------------------*/
        
        add_action( 'init', 'Advanced_Themer_Bricks\AT__Admin::register_scripts' );
        add_action( 'admin_enqueue_scripts', 'Advanced_Themer_Bricks\AT__Admin::admin_enqueue_scripts' );
        add_action( 'get_footer', 'Advanced_Themer_Bricks\AT__Admin::enqueue_builder_scripts' );
        add_action( 'acf/input/admin_enqueue_scripts', 'Advanced_Themer_Bricks\AT__ACF::acf_admin_enqueue_scripts' );
        
        /*--------------------------------------
        Global Colors & Variables
        --------------------------------------*/
        add_action( 'init', 'Advanced_Themer_Bricks\AT__Global_Colors::theme_support_load_gutenberg_colors', 30 );
        add_action( 'enqueue_block_assets', 'Advanced_Themer_Bricks\AT__Frontend::enqueue_gutenberg_colors_in_iframe'  );
        add_action( 'init', 'Advanced_Themer_Bricks\AT__Frontend::remove_default_gutenberg_presets' );
        
        add_action( 'wp_enqueue_scripts', 'Advanced_Themer_Bricks\AT__Frontend::load_variables_on_frontend', 2, 5 );
        add_action( 'admin_enqueue_scripts', 'Advanced_Themer_Bricks\AT__Admin::load_variables_on_backend' );
        add_action( 'init', 'Advanced_Themer_Bricks\AT__Frontend::meta_theme_color_tag');
        
        /*--------------------------------------
        Add Admin Bar Menu Item
        --------------------------------------*/
        
        add_action( 'admin_bar_menu', 'Advanced_Themer_Bricks\AT__Admin::add_admin_bar_menu', 100);
        add_action( 'wp_footer', 'Advanced_Themer_Bricks\AT__Builder::add_modal_after_body_wrapper' );
        add_action( 'wp_footer', 'Advanced_Themer_Bricks\AT__Builder::add_modal_after_body_wrapper_editor' );
        

        /*--------------------------------------
        Register New Bricks Elements
        --------------------------------------*/
        
        add_action( 'init',  'Advanced_Themer_Bricks\AT__Helpers::register_bricks_elements', 11 );
  

        /*--------------------------------------
        Class Importer
        --------------------------------------*/

        add_action( 'init', 'Advanced_Themer_Bricks\AT__Class_Importer::enqueue_uploaded_css' );

        /*--------------------------------------
        Global Query Loops
        --------------------------------------*/

        add_filter( 'bricks/setup/control_options', 'Advanced_Themer_Bricks\AT__Builder::setup_query_controls');
        add_filter( 'bricks/query/run', 'Advanced_Themer_Bricks\AT__Builder::maybe_run_new_queries', 10, 2);
        add_filter( 'bricks/query/loop_object', 'Advanced_Themer_Bricks\AT__Builder::setup_post_data', 10, 3);

        /*--------------------------------------
        Templates
        --------------------------------------*/

        add_filter('manage_bricks_template_posts_columns', 'Advanced_Themer_Bricks\AT__Admin::custom_add_image_column', 999);
        add_action('manage_bricks_template_posts_custom_column', 'Advanced_Themer_Bricks\AT__Admin::custom_image_column_content', 10, 2);
        add_filter('manage_edit-bricks_template_sortable_columns', 'Advanced_Themer_Bricks\AT__Admin::custom_image_column_sortable');
        add_action('admin_enqueue_scripts', 'Advanced_Themer_Bricks\AT__Admin::enqueue_custom_css_for_bricks_template');

        /*--------------------------------------
        AJAX Request
        --------------------------------------*/

        add_action( 'wp_ajax_openai_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::openai_ajax_function' );
        add_action( 'wp_ajax_nopriv_openai_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::openai_ajax_function' );
        add_action( 'wp_ajax_openai_save_image_to_media_library', 'Advanced_Themer_Bricks\AT__Builder::openai_save_image_to_media_library' );
        add_action( 'wp_ajax_nopriv_openai_save_image_to_media_library', 'Advanced_Themer_Bricks\AT__Builder::openai_save_image_to_media_library' );
        add_action( 'wp_ajax_reset_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::reset_advanced_options_callback');
        add_action( 'wp_ajax_norpiv_reset_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::reset_advanced_options_callback');
        add_action( 'wp_ajax_export_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::export_advanced_options_callback');
        add_action( 'wp_ajax_norpiv_export_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::export_advanced_options_callback');
        add_action( 'wp_ajax_import_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::import_advanced_options_callback');
        add_action( 'wp_ajax_norpiv_import_advanced_options', 'Advanced_Themer_Bricks\AT__Builder::import_advanced_options_callback');
        add_action( 'wp_ajax_save_global_css_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_global_css_ajax_function' );
        add_action( 'wp_ajax_nopriv_save_global_css_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_global_css_ajax_function' );
        add_action( 'wp_ajax_save_grid_guide_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_grid_guide_ajax_function' );
        add_action( 'wp_ajax_nopriv_save_grid_guide_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_grid_guide_ajax_function' );
        add_action( 'wp_ajax_save_query_manager_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_query_manager_ajax_function' );
        add_action( 'wp_ajax_nopriv_save_query_manager_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::save_query_manager_ajax_function' );
        add_action( 'wp_ajax_save_full_access_ajax_function', 'Advanced_Themer_Bricks\AT__Ajax::save_full_access_ajax_function' );
        add_action( 'wp_ajax_nopriv_save_full_access_ajax_function', 'Advanced_Themer_Bricks\AT__Ajax::save_full_access_ajax_function' );
        add_action( 'wp_ajax_get_var_query_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::get_var_query_ajax_function');
        add_action( 'wp_ajax_nopriv_get_var_query_ajax_function', 'Advanced_Themer_Bricks\AT__Builder::get_var_query_ajax_function');
        add_action( 'wp_ajax_save_section_template_ajax_function', 'Advanced_Themer_Bricks\AT__Ajax::save_section_template_ajax_function');
        add_action( 'wp_ajax_nopriv_save_section_template_ajax_function', 'Advanced_Themer_Bricks\AT__Ajax::save_section_template_ajax_function');

        /*--------------------------------------
        Strict Editor View
        --------------------------------------*/
        add_filter( 'init', 'Advanced_Themer_Bricks\AT__Builder::set_full_access_to_all_elements', 997);
        add_filter( 'init', 'Advanced_Themer_Bricks\AT__Builder::set_full_access_settings', 998);
        add_filter( 'admin_menu', 'Advanced_Themer_Bricks\AT__Admin::remove_templates_from_menu', 999 );
        add_action( 'wp_before_admin_bar_render', 'Advanced_Themer_Bricks\AT__Admin::remove_templates_from_toolbar', 999); 
        add_filter( 'bricks/acf/filter_field_groups' , function($groups){
            foreach($groups as $key => $value){
                if($value['key'] === 'group_638315a281bf1' || $value['key'] === 'group_6389e81fa2085'){
                    unset($groups[$key]);
                }
            }
            return $groups;
        });

        /*--------------------------------------
        Allow JSON upload
        --------------------------------------*/
        add_filter( 'upload_mimes', 'Advanced_Themer_Bricks\AT__Helpers::add_upload_mimes' );

        /*--------------------------------------
        Custom default Values in builder
        --------------------------------------*/
        add_filter( 'init', 'Advanced_Themer_Bricks\AT__Builder::set_custom_default_values_in_builder', 999);
        add_filter( 'init', 'Advanced_Themer_Bricks\AT__Builder::disable_bricks_elements');

        /*--------------------------------------
        Scoped Variables
        --------------------------------------*/
        //add_filter( 'init', 'Advanced_Themer_Bricks\AT__Frontend::load_scoped_variables_on_id');

    }
    
}