<?php
namespace Bricks;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class I18n {
	public static function get_frontend_i18n() {
		return [
			'openAccordion'    => esc_html__( 'Open accordion', 'bricks' ),
			'openMobileMenu'   => esc_html__( 'Open mobile menu', 'bricks' ),
			'closeMobileMenu'  => esc_html__( 'Close mobile menu', 'bricks' ),
			'showPassword'     => esc_html__( 'Show password', 'bricks' ),
			'hidePassword'     => esc_html__( 'Hide password', 'bricks' ),
			'prevSlide'        => esc_html__( 'Previous slide', 'bricks' ),
			'nextSlide'        => esc_html__( 'Next slide', 'bricks' ),
			'firstSlide'       => esc_html__( 'Go to first slide', 'bricks' ),
			'lastSlide'        => esc_html__( 'Go to last slide', 'bricks' ),
			/* translators: %s: slide number */
			'slideX'           => esc_html__( 'Go to slide %s', 'bricks' ),
			'play'             => esc_html__( 'Start autoplay', 'bricks' ),
			'pause'            => esc_html__( 'Pause autoplay', 'bricks' ),
			'splide'           => [
				'carousel'   => esc_html__( 'carousel', 'bricks' ),
				'select'     => esc_html__( 'Select a slide to show', 'bricks' ),
				'slide'      => esc_html__( 'slide', 'bricks' ),
				/* translators: %1$s: current slide number, %2$s: total slides */
				'slideLabel' => esc_html__( '%1$s of %2$s', 'bricks' ),
			],
			'swiper'           => [
				/* translators: {{index}}: current slide number, {{slidesLength}}: total slides */
				'slideLabelMessage' => esc_html__( '{{index}} / {{slidesLength}}', 'bricks' ),
			],
			'noLocationsFound' => esc_html__( 'No locations found', 'bricks' ),
			'locationTitle'    => esc_html__( 'Location title', 'bricks' ),
			'locationSubtitle' => esc_html__( 'Location subtitle', 'bricks' ),
			'locationContent'  => esc_html__( 'Location content', 'bricks' ),
		];
	}

	public static function get_admin_i18n() {
		return [
			'capability'                              => esc_html__( 'Capability', 'bricks' ),
			'capabilityKey'                           => esc_html__( 'Key', 'bricks' ),
			'capabilityName'                          => esc_html__( 'Name', 'bricks' ),
			'capabilityNameRequired'                  => esc_html__( 'Name is required', 'bricks' ),
			'cleanupAllOrphanedElements'              => esc_html__( 'Clean up all orphaned elements', 'bricks' ),
			'close'                                   => esc_html__( 'Close', 'bricks' ),
			'confirmCleanupOrphanedElements'          => esc_html__( 'Are you sure you want to remove all orphaned elements from your site? This action cannot be undone. Please perform a backup of your site before you proceed.', 'bricks' ),
			'confirmDeleteCapability'                 => esc_html__( 'You are about to delete this capability. Do you wish to proceed?', 'bricks' ),
			'confirmResetSettings'                    => esc_html__( 'You are about to reset all Bricks global settings. Do you wish to proceed?', 'bricks' ),
			'confirmDropFormSubmissionsTable'         => esc_html__( 'You are about to delete all form submissions (including the database table). Do you wish to proceed?', 'bricks' ),
			'confirmResetFormSubmissionsTable'        => esc_html__( 'You are about to delete all form submissions. Do you wish to proceed?', 'bricks' ),
			'confirmResetFormSubmissionsFormId'       => sprintf( esc_html__( 'You are about to delete all form submissions of form ID %s. Do you wish to proceed?', 'bricks' ), '[form_id]' ),
			'confirmDeleteTemplateScreenshots'        => esc_html__( 'You are about to delete all template screenshots. Not your featured images, though. Do you wish to proceed?', 'bricks' ),
			'confirmReindexFilters'                   => esc_html__( 'You are about to regenerate indexes for all query filters. Do you wish to proceed?', 'bricks' ),
			'confirmRegenerateCodeSignatures'         => esc_html__( 'You are about to regenerate code signatures for all executable code on your website. Please ensure you have a recent backup before continuing. Do you wish to proceed?', 'bricks' ),
			'confirmRemoveAllIndexJobs'               => esc_html__( 'You are about to remove all index jobs. Do you wish to proceed?', 'bricks' ),
			'confirmTriggerIndexJob'                  => esc_html__( 'You are about to trigger Index Job. Do you wish to proceed?', 'bricks' ),
			'confirmFixElementDB'                     => esc_html__( 'You are about to fix the element database. Do you wish to proceed?', 'bricks' ),
			'customCapabilities'                      => esc_html__( 'Custom capabilities', 'bricks' ),
			'customCapabilitiesDescription'           => esc_html__( 'Once done editing, click the "Save Settings" button at the bottom below to persist your changes.', 'bricks' ),
			'default'                                 => esc_html__( 'Default', 'bricks' ),
			'defaultCapabilities'                     => esc_html__( 'Default capabilities', 'bricks' ),
			'delete'                                  => esc_html__( 'Delete', 'bricks' ),
			'deleteSelected'                          => esc_html__( 'Delete selected', 'bricks' ),
			'description'                             => esc_html__( 'Description', 'bricks' ),
			'duplicate'                               => esc_html__( 'Duplicate', 'bricks' ),
			'edit'                                    => esc_html__( 'Edit', 'bricks' ),
			'editCapability'                          => esc_html__( 'Edit capability', 'bricks' ),
			'errorOccurred'                           => esc_html__( 'An error occurred.', 'bricks' ),
			'errorOccurredCleaningUpOrphanedElements' => esc_html__( 'An error occurred while cleaning up orphaned elements.', 'bricks' ),
			'errorOccurredScanningOrphanedElements'   => esc_html__( 'An error occurred while scanning for orphaned elements.', 'bricks' ),
			'enableAll'                               => esc_html__( 'Enable all', 'bricks' ),
			'formSubmissionsSearchPlaceholder'        => esc_html__( 'Form data', 'bricks' ),
			'globalElementsConvertConfirm'            => esc_html__( 'Do you want to unlink all nestable global elements?', 'bricks' ),
			'selectItems'                             => esc_html__( 'Select items', 'bricks' ),
			'searchItems'                             => esc_html__( 'Add / Search for', 'bricks' ),
			'selectTemplates'                         => esc_html__( 'Select templates', 'bricks' ),
			'searchTemplates'                         => esc_html__( 'Add / Search for templates', 'bricks' ),
			'selectColor'                             => esc_html__( 'Select color', 'bricks' ),
			'selectPosts'                             => esc_html__( 'Select posts/pages', 'bricks' ),
			'searchPosts'                             => esc_html__( 'Search posts/pages', 'bricks' ),
			'typeToSearch'                            => esc_html__( 'Type to search', 'bricks' ),
			'results'                                 => esc_html__( 'Results', 'bricks' ),
			'remove'                                  => esc_html__( 'Remove', 'bricks' ),
			'searching'                               => esc_html__( 'Searching', 'bricks' ) . ' ...',
			'noResults'                               => esc_html__( 'No results found', 'bricks' ),
			'searchError'                             => esc_html__( 'Error loading results', 'bricks' ),
			'minSearchLength'                         => esc_html__( 'Please enter at least 2 characters', 'bricks' ) . ' ...',
			'newCapability'                           => esc_html__( 'New capability', 'bricks' ),
			'noOrphanedElementsFound'                 => esc_html__( 'No orphaned elements found.', 'bricks' ),
			// translators: %d: Number of orphaned elements found in this specific post
			'orphanedElementsCountMessage'            => esc_html__( '%d orphaned elements found', 'bricks' ),
			// translators: %1$d: Number of orphaned elements found, %2$d: Number of posts affected
			'orphanedElementsFoundMessage'            => esc_html__( '%1$d orphaned elements found across %2$d posts. Click "Clean up all orphaned elements" to remove all orphaned elements from your site. Please backup your site before you proceed.', 'bricks' ),
			'orphanedElementsReview'                  => esc_html__( 'Orphaned elements review', 'bricks' ),
			'removingIndexJobsInfo'                   => esc_html__( 'Do not close this window, the process is running in the background.', 'bricks' ),
			'updateCapability'                        => esc_html__( 'Close', 'bricks' ),
			'view'                                    => esc_html__( 'View', 'bricks' ),
			'saveChanges'                             => esc_html__( 'Save changes', 'bricks' ),
			'saveSettingsToApplyChanges'              => esc_html__( 'Make sure to save settings after closing this modal to apply changes', 'bricks' ),
			// Gutenberg
			'editWithBricks'                          => // translators: %s: "Bricks" (theme name)
				sprintf( esc_html__( 'Edit with %s', 'bricks' ), 'Bricks' ),
			'useDefaultEditor'                        => esc_html__( 'Use block editor', 'bricks' ),
			// translators: %s: "Bricks" (theme name)
			'bricksActiveMessage'                     => sprintf( esc_html__( 'This page is built with %s.', 'bricks' ), 'Bricks' ),
		];
	}

	public static function get_builder_i18n() {
		return [
			'accept'                                      => esc_html__( 'Accept', 'bricks' ),
			'action'                                      => esc_html__( 'Action', 'bricks' ),
			'actions'                                     => esc_html__( 'Actions', 'bricks' ),
			'active'                                      => esc_html__( 'Active', 'bricks' ),
			'activeClass'                                 => esc_html__( 'Active class', 'bricks' ),
			'activeClasses'                               => esc_html__( 'Active classes', 'bricks' ),
			'activeStyles'                                => esc_html__( 'Active styles', 'bricks' ),
			'add'                                         => esc_html__( 'Add', 'bricks' ),
			'addToFavorites'                              => esc_html__( 'Add to favorites', 'bricks' ),
			'added'                                       => esc_html__( 'Added', 'bricks' ),
			'addImages'                                   => esc_html__( 'Add images', 'bricks' ),
			'addItem'                                     => esc_html__( 'Add Item', 'bricks' ),
			'addPrefix'                                   => esc_html__( 'Add prefix', 'bricks' ),
			'addSuffix'                                   => esc_html__( 'Add suffix', 'bricks' ),
			'addToIconSet'                                => esc_html__( 'Add to icon set', 'bricks' ),
			'ajaxLoader'                                  => esc_html__( 'AJAX loader', 'bricks' ),
			'ajaxLoaderDesc'                              => esc_html__( 'Shows when using infinite scroll, load more interaction, AJAX pagination.', 'bricks' ),
			'ajaxLoaderSelector'                          => esc_html__( 'CSS selector', 'bricks' ),
			'ajaxLoaderSelectorDesc'                      => esc_html__( 'CSS selector of the element to insert the AJAX loader into.', 'bricks' ),
			'ajaxLoaderAnimation'                         => esc_html__( 'Animation', 'bricks' ),

			'align'                                       => esc_html__( 'Align', 'bricks' ),
			'alignItems'                                  => esc_html__( 'Align items', 'bricks' ),
			'all'                                         => esc_html__( 'All', 'bricks' ),
			'alpha'                                       => esc_html__( 'Transparency', 'bricks' ),
			'alphabetically'                              => esc_html__( 'Alphabetically', 'bricks' ),
			'and'                                         => esc_html__( 'And', 'bricks' ),
			'angle'                                       => esc_html__( 'Angle in °', 'bricks' ),
			'any'                                         => esc_html__( 'Any', 'bricks' ),
			'anyBreakpoint'                               => esc_html__( 'Any breakpoint', 'bricks' ),
			'apply'                                       => esc_html__( 'Apply', 'bricks' ),
			'applyTo'                                     => esc_html__( 'Apply to', 'bricks' ),
			'archive'                                     => esc_html__( 'Archive', 'bricks' ),
			'arrows'                                      => esc_html__( 'Arrows', 'bricks' ),
			'ascending'                                   => esc_html__( 'Ascending', 'bricks' ),
			'auto'                                        => esc_html__( 'Auto', 'bricks' ),
			'author'                                      => esc_html__( 'Author', 'bricks' ),
			'attachment'                                  => esc_html__( 'Attachment', 'bricks' ),
			'attribute'                                   => esc_html__( 'Attribute', 'bricks' ),
			'attributes'                                  => esc_html__( 'Attributes', 'bricks' ),
			'autosaveBy'                                  => esc_html__( 'Autosave by', 'bricks' ),

			'back'                                        => esc_html__( 'Back', 'bricks' ),
			'backToIconSets'                              => esc_html__( 'Back to icon sets', 'bricks' ),
			'background'                                  => esc_html__( 'Background', 'bricks' ),
			'backgroundColor'                             => esc_html__( 'Background color', 'bricks' ),
			'backgroundCustomSize'                        => esc_html__( 'Background custom size', 'bricks' ),
			'backgroundImage'                             => esc_html__( 'Background image', 'bricks' ),
			'backgroundPosition'                          => esc_html__( 'Background position', 'bricks' ),
			'backgroundRepeat'                            => esc_html__( 'Background repeat', 'bricks' ),
			'backgroundSize'                              => esc_html__( 'Background size', 'bricks' ),
			'backgroundAttachment'                        => esc_html__( 'Background attachment', 'bricks' ),
			'backgroundBlendMode'                         => esc_html__( 'Background blend mode', 'bricks' ),
			'backgroundVideo'                             => esc_html__( 'Background video', 'bricks' ),
			'backgroundVideoAspectRatio'                  => esc_html__( 'Aspect ratio', 'bricks' ),
			'backgroundVideoStartAt'                      => esc_html__( 'Select smallest breakpoint that this video should play at. Preview on frontend.', 'bricks' ),
			'backgroundVideoDescription'                  => esc_html__( 'File URL, YouTube/Vimeo URL/ID.', 'bricks' ),
			'backgroundVideoPoster'                       => esc_html__( 'Poster image', 'bricks' ),
			'backgroundVideoPosterYouTube'                => esc_html__( 'Auto poster', 'bricks' ) . ' (YouTube)',
			'backgroundVideoPosterYouTubeSize'            => esc_html__( 'Poster size for YouTube', 'bricks' ),
			'backgroundVideoPosterYouTubeSizePlaceholder' => esc_html__( 'Max resolution', 'bricks' ),
			'backToBuilder'                               => esc_html__( 'Back to builder', 'bricks' ),
			'backToImportManager'                         => esc_html__( 'Back to import manager', 'bricks' ),
			'baseBreakpoint'                              => esc_html__( 'Base breakpoint', 'bricks' ),
			'baseline'                                    => esc_html__( 'Baseline', 'bricks' ),
			'basic'                                       => esc_html__( 'Basic', 'bricks' ),
			'blockquote'                                  => esc_html__( 'Blockquote', 'bricks' ),
			'align'                                       => esc_html__( 'Align', 'bricks' ),
			'bulletedList'                                => esc_html__( 'Bullet List', 'bricks' ),
			'block'                                       => esc_html__( 'Block', 'bricks' ),
			'blur'                                        => esc_html__( 'Blur', 'bricks' ),
			'bold'                                        => esc_html__( 'Bold', 'bricks' ),
			'border'                                      => esc_html__( 'Border', 'bricks' ),
			'borderColor'                                 => esc_html__( 'Border color', 'bricks' ),
			'bottom'                                      => esc_html__( 'Bottom', 'bricks' ),
			'bottomLeft'                                  => esc_html__( 'Bottom left', 'bricks' ),
			'bottomCenter'                                => esc_html__( 'Bottom center', 'bricks' ),
			'bottomRight'                                 => esc_html__( 'Bottom right', 'bricks' ),
			'boxShadow'                                   => esc_html__( 'Box shadow', 'bricks' ),
			'breakpoint'                                  => esc_html__( 'Breakpoint', 'bricks' ),
			'breakpoints'                                 => esc_html__( 'Breakpoints', 'bricks' ),
			'breakpointBaseMessage'                       => esc_html__( 'Editing the base breakpoint width affects all media queries.', 'bricks' ),
			'breakpointLabelErrorMessage'                 => esc_html__( 'Breakpoint label must start with a letter.', 'bricks' ),
			'breakpointDeleteDescription'                 => esc_html__( 'Are you sure that you want to delete this breakpoint?', 'bricks' ),
			'bricksSettings'                              => sprintf( esc_html__( '%s settings', 'bricks' ), 'Bricks' ),
			'brightness'                                  => esc_html__( 'Brightness', 'bricks' ),
			'browse'                                      => esc_html__( 'Browse', 'bricks' ),
			'browseMediaLibrary'                          => esc_html__( 'Browse Media Library', 'bricks' ),
			'browseUnsplash'                              => esc_html__( 'Browse Unsplash', 'bricks' ),
			'builder'                                     => esc_html__( 'Builder', 'bricks' ),
			'builtInIconSets'                             => esc_html__( 'Built-in icon sets', 'bricks' ),
			'builderHelpTitle'                            => esc_html__( 'Need help? Found a bug? Suggest a feature?', 'bricks' ),
			'builderHelpDescription'                      => sprintf(
				// translators: %s: Bricks support email address (link)
				__( 'Please use your Bricks account email address for all customer support requests. To attach larger files, please send an email directly to %1$s. To see what is currently in development or submit/upvote feature requests please visit our %2$s.', 'bricks' ),
				'<a href="mailto:help@bricksbuilder.io" target="_blank">help@bricksbuilder.io</a>',
				'<a href="https://bricksbuilder.io/roadmap/" target="_blank" rel="noopener">' . esc_html__( 'official roadmap', 'bricks' ) . '</a>'
			),
			// translators: %s: Max. upload size (e.g. 2 MB)
			'builderHelpUploadLimitExceeded'              => sprintf( esc_html__( 'Your attached files exceed your server max. upload size of %s.', 'bricks' ), size_format( wp_max_upload_size() ) ),
			'builderHelpGmailLimitExceeded'               => esc_html__( 'Your attached files exceed the max. upload limit of 25 MB.', 'bricks' ),
			'bulletedlist'                                => esc_html__( 'Bulleted list', 'bricks' ),
			'bulkActions'                                 => esc_html__( 'Bulk actions', 'bricks' ),
			'bulkEdit'                                    => esc_html__( 'Bulk edit', 'bricks' ),
			'bulkEditNotSupported'                        => esc_html__( 'Not possible while bulk-editing.', 'bricks' ),
			'bulkEditMoveError'                           => esc_html__( 'All selected elements must have the same parent', 'bricks' ),
			'by'                                          => esc_html__( 'by', 'bricks' ),

			'cancel'                                      => esc_html__( 'Cancel', 'bricks' ),
			'capitalize'                                  => esc_html__( 'Capitalize', 'bricks' ),
			'cartCrossSells'                              => esc_html__( 'Cart Cross-sells', 'bricks' ),
			'cartCrossSellsQueryDescription'              => esc_html__( 'Place this query on the cart page.', 'bricks' ),
			'categories'                                  => esc_html__( 'Categories', 'bricks' ),
			'categorize'                                  => esc_html__( 'Categorize', 'bricks' ),
			'category'                                    => esc_html__( 'Category', 'bricks' ),
			'categoriesDeleted'                           => esc_html__( 'Categories deleted', 'bricks' ),
			'category'                                    => esc_html__( 'Category', 'bricks' ),
			'categoriesImported'                          => esc_html__( 'Categories imported', 'bricks' ),
			'categoryNamePlaceholder'                     => esc_html__( 'New category name', 'bricks' ),
			'center'                                      => esc_html__( 'Center', 'bricks' ),
			'centerLeft'                                  => esc_html__( 'Center left', 'bricks' ),
			'centerCenter'                                => esc_html__( 'Center center', 'bricks' ),
			'centerRight'                                 => esc_html__( 'Center right', 'bricks' ),
			'childOf'                                     => esc_html__( 'Child of', 'bricks' ),
			'childless'                                   => esc_html__( 'Childless', 'bricks' ),
			'circle'                                      => esc_html__( 'Circle', 'bricks' ),
			'checkbox'                                    => esc_html__( 'Checkbox', 'bricks' ),
			'chooseFiles'                                 => esc_html__( 'Choose files', 'bricks' ),
			'chooseImage'                                 => esc_html__( 'Choose image', 'bricks' ),
			'class'                                       => esc_html__( 'Class', 'bricks' ),
			'classes'                                     => esc_html__( 'Classes', 'bricks' ),
			'className'                                   => esc_html__( 'Class name', 'bricks' ),
			'classNameExists'                             => esc_html__( 'Class name already exists', 'bricks' ),
			'classNamePlaceholder'                        => esc_html__( 'New class name', 'bricks' ),
			'clickToDownload'                             => esc_html__( 'Click to download', 'bricks' ),
			'classesDiscarded'                            => esc_html__( 'Classes discarded', 'bricks' ),
			'classesDuplicated'                           => esc_html__( 'Classes duplicated', 'bricks' ),
			'classesFound'                                => esc_html__( 'Classes found', 'bricks' ),
			'classesRenamed'                              => esc_html__( 'Classes renamed', 'bricks' ),
			'clauseName'                                  => esc_html__( 'Clause name', 'bricks' ),
			'clauseNameDesc'                              => esc_html__( 'Set clause name to be used as "Order by" parameter.', 'bricks' ),
			'clone'                                       => esc_html__( 'Clone', 'bricks' ),
			'cloned'                                      => esc_html__( 'cloned', 'bricks' ),
			'clean'                                       => esc_html__( 'Clean', 'bricks' ),
			'cleanUp'                                     => esc_html__( 'Clean up', 'bricks' ),
			'clear'                                       => esc_html__( 'Clear', 'bricks' ),
			'close'                                       => esc_html__( 'Close', 'bricks' ),
			'closestSide'                                 => esc_html__( 'Closest side', 'bricks' ),
			'closestCorner'                               => esc_html__( 'Closest corner', 'bricks' ),
			'closeEsc'                                    => esc_html__( 'Close (ESC)', 'bricks' ),
			'collapse'                                    => esc_html__( 'Collapse', 'bricks' ),
			'codeSignatures'                              => esc_html__( 'Code signatures', 'bricks' ),
			'codeSigned'                                  => esc_html__( 'Code signed', 'bricks' ),
			'codeSignaturesDescription'                   => esc_html__( 'Elements without code signature. Review, then sign your code one-by-one or all-at-once.', 'bricks' ),
			'color'                                       => esc_html__( 'Color', 'bricks' ),
			'colors'                                      => esc_html__( 'Colors', 'bricks' ),
			'colorStop'                                   => esc_html__( 'Color stop', 'bricks' ),
			'colorPalette'                                => esc_html__( 'Color palette', 'bricks' ),
			'colorPreview'                                => esc_html__( 'Color preview', 'bricks' ),
			'column'                                      => esc_html__( 'Column', 'bricks' ),
			'columns'                                     => esc_html__( 'Columns', 'bricks' ),
			'commandPalette'                              => esc_html__( 'Command palette', 'bricks' ),
			'commandPaletteInputPlaceholder'              => esc_html__( 'Enter a search term or command', 'bricks' ) . ' ...',
			'commandPaletteInputPlaceholderGoTo'          => esc_html__( 'Search or create post', 'bricks' ) . ' ...',
			'commandPaletteInputPlaceholderElements'      => '@section * 2 > @block > @heading + @button',
			'commandPaletteInputPlaceholderSave'          => esc_html__( 'Element structure name', 'bricks' ) . ' (' . esc_html__( 'Optional', 'bricks' ) . ')',
			'commandPaletteSelectPlaceholderElements'     => esc_html__( 'Select element structure', 'bricks' ),
			'commandPaletteMoreResults'                   => esc_html__( 'You are viewing the first 1000 results. Perform search to see more.', 'bricks' ),
			'commandPaletteInsertElementsInfo'            => esc_html__( 'Insert elements in Emmet-like syntax.', 'bricks' ) . ' ' . Helpers::article_link( 'command-palette/#elements', esc_html__( 'Learn more', 'bricks' ) ),
			'commonClasses'                               => esc_html__( 'Common classes', 'bricks' ),
			'community'                                   => esc_html__( 'Community', 'bricks' ),
			'communityTemplates'                          => esc_html__( 'Community templates', 'bricks' ),
			'compare'                                     => esc_html__( 'Compare', 'bricks' ),
			'component'                                   => esc_html__( 'Component', 'bricks' ),
			'components'                                  => esc_html__( 'Components', 'bricks' ),
			'componentNotFoundInfo'                       => esc_html__( 'Element can\'t be rendered as the connected component doesn\'t exist. Unlink this instance or import the missing component.', 'bricks' ),
			'condition'                                   => esc_html__( 'Condition', 'bricks' ),
			'conditions'                                  => esc_html__( 'Conditions', 'bricks' ),
			'conditionSelect'                             => esc_html__( 'Select condition', 'bricks' ),
			'conditionTiming'                             => esc_html__( 'Conditions always run before query loop.', 'bricks' ),
			'configure'                                   => esc_html__( 'Configure', 'bricks' ),
			'confirm'                                     => esc_html__( 'Confirm', 'bricks' ),
			'confirmDeleteIconSet'                        => esc_html__( 'Are you sure you want to delete this icon set?', 'bricks' ),
			'confirmDeletePermanently'                    => esc_html__( 'Permanently delete this icon? This action cannot be undone.', 'bricks' ),
			'confirmIconManageRemoveIcons'                => esc_html__( 'You are about to remove all selected icons from this set. Do you wish to proceed?', 'bricks' ),
			'confirmMoveToTrash'                          => esc_html__( 'Are you sure you want to move this font to the trash?', 'bricks' ),
			'conflict'                                    => esc_html__( 'Conflict', 'bricks' ),
			'conflicts'                                   => esc_html__( 'Conflicts', 'bricks' ),
			'conflictsDesc'                               => esc_html__( 'Resolve all conflicts listed below to save your changes.', 'bricks' ),
			'conflictsDesc2'                              => esc_html__( 'Click "Accept" to use the incoming database changes. Click "Discard" to save your current builder data instead.', 'bricks' ),
			'conic'                                       => esc_html__( 'Conic', 'bricks' ),
			'connect'                                     => esc_html__( 'Connect', 'bricks' ),
			'connectProperty'                             => esc_html__( 'Connect property', 'bricks' ),
			'connectedProperty'                           => esc_html__( 'Connected property', 'bricks' ),
			'contactUs'                                   => esc_html__( 'Contact us', 'bricks' ),
			'contain'                                     => esc_html__( 'Contain', 'bricks' ),
			'container'                                   => esc_html__( 'Container', 'bricks' ),
			'content'                                     => esc_html__( 'Content', 'bricks' ),
			'contenteditablePlaceholder'                  => esc_html__( 'Here goes my text ...', 'bricks' ),
			'contrast'                                    => esc_html__( 'Contrast', 'bricks' ),
			'controls'                                    => esc_html__( 'Controls', 'bricks' ),
			'convert'                                     => esc_html__( 'Convert', 'bricks' ),
			'copied'                                      => esc_html__( 'Copied', 'bricks' ),
			'copiedToClipboard'                           => esc_html__( 'Copied to clipboard', 'bricks' ),
			'copy'                                        => esc_html__( 'Copy', 'bricks' ),
			'copyToClipboard'                             => esc_html__( 'Copy to clipboard', 'bricks' ),
			'copyElementSelector'                         => esc_html__( 'Copy CSS selector', 'bricks' ),
			'cover'                                       => esc_html__( 'Cover', 'bricks' ),
			'current'                                     => esc_html__( 'Current', 'bricks' ),
			'currentPage'                                 => esc_html__( 'Current page', 'bricks' ),
			'currentPostAuthor'                           => esc_html__( 'Current post author', 'bricks' ),
			'currentPostTerm'                             => esc_html__( 'Current post term', 'bricks' ),
			'createComponent'                             => esc_html__( 'Create component', 'bricks' ),
			'createProperty'                              => esc_html__( 'Create property', 'bricks' ),
			'create'                                      => esc_html__( 'Create', 'bricks' ),
			'createIconSet'                               => esc_html__( 'Create icon set', 'bricks' ),
			'created'                                     => esc_html__( 'Created', 'bricks' ),
			'createTemplate'                              => esc_html__( 'Create template', 'bricks' ),
			'createTemplateTitlePlaceholder'              => esc_html__( 'Template title', 'bricks' ),
			'createTemplateTitle'                         => esc_html__( 'Create new template:', 'bricks' ),
			'createYourOwnElements'                       => esc_html__( 'Create your own elements', 'bricks' ),
			'crossSells'                                  => esc_html__( 'Cross-sells', 'bricks' ),
			'crossSellsQueryDescription'                  => esc_html__( 'Place this query on the product page.', 'bricks' ),
			'cssClass'                                    => esc_html__( 'CSS class', 'bricks' ),
			'cssClassName'                                => esc_html__( 'Class name', 'bricks' ),
			'cssClassesTooltip'                           => esc_html__( 'Separated by space. No leading dot "."', 'bricks' ),
			'cssIdTooltip'                                => esc_html__( 'No leading pound sign "#"', 'bricks' ),
			'cssFilter'                                   => esc_html__( 'CSS filter', 'bricks' ),
			'cssFilterDescription'                        => '<a target="_blank" href="https://developer.mozilla.org/en/docs/Web/CSS/filter?v=example">' . esc_html__( 'Enter CSS filters + value (learn more)', 'bricks' ) . '</a>',
			'cssSelector'                                 => esc_html__( 'CSS selector', 'bricks' ),
			'currentLayout'                               => esc_html__( 'Current layout', 'bricks' ),
			'currentVersionBy'                            => esc_html__( 'Current version by', 'bricks' ),
			'currentWidth'                                => esc_html__( 'Current width', 'bricks' ),
			'custom'                                      => esc_html__( 'Custom', 'bricks' ),
			'customIconSets'                              => esc_html__( 'Custom icon sets', 'bricks' ),
			'customCss'                                   => esc_html__( 'Custom CSS', 'bricks' ),
			'customFields'                                => esc_html__( 'Custom fields', 'bricks' ),
			'customFont'                                  => esc_html__( 'Custom font', 'bricks' ),
			'customUrl'                                   => esc_html__( 'Custom URL', 'bricks' ),

			'dashboard'                                   => esc_html__( 'Dashboard', 'bricks' ),
			'data'                                        => esc_html__( 'Data', 'bricks' ),
			'default'                                     => esc_html__( 'Default', 'bricks' ),
			// translators: %s: Default templates are disabled.
			'defaultTemplatesDisabled'                    => sprintf( esc_html__( '%s. Set template conditions or enable default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . esc_html__( 'Default templates are disabled', 'bricks' ) . '</a>' ),
			// translators: %s: Default templates are enabled.
			'defaultTemplatesEnabled'                     => sprintf( esc_html__( '%s. Template conditions precede default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . esc_html__( 'Default templates are enabled', 'bricks' ) . '</a>' ),
			// translators: %s: Default templates are disabled.
			'defaultTemplatesDisabled'                    => sprintf( esc_html__( '%s. Set template conditions or enable default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . esc_html__( 'Default templates are disabled', 'bricks' ) . '</a>' ),
			'dashed'                                      => esc_html__( 'dashed', 'bricks' ),
			'date'                                        => esc_html__( 'Date', 'bricks' ),
			'delay'                                       => esc_html__( 'Delay', 'bricks' ),
			'delete'                                      => esc_html__( 'Delete', 'bricks' ),
			'deleteIcon'                                  => esc_html__( 'Delete icon', 'bricks' ),
			'deleted'                                     => esc_html__( 'Deleted', 'bricks' ),
			'deleteAll'                                   => esc_html__( 'Delete all', 'bricks' ),
			'deleteComponentsInfo'                        => esc_html__( 'Export all components first by clicking the "Export" icon above before deleting any. Once exported, hover over the component you\'d like to delete, then click the "Delete" icon.', 'bricks' ),
			'deletePermanently'                           => esc_html__( 'Delete permanently', 'bricks' ),
			'deleteSelected'                              => esc_html__( 'Delete selected', 'bricks' ),
			'deprecated'                                  => esc_html__( 'Deprecated', 'bricks' ),
			'descending'                                  => esc_html__( 'Descending', 'bricks' ),
			'description'                                 => esc_html__( 'Description', 'bricks' ),
			'descriptionLightboxVideo'                    => esc_html__( 'YouTube, Vimeo or file URL.', 'bricks' ),
			'descriptionParallax'                         => esc_html__( 'Set to "Fixed" for parallax effect.', 'bricks' ),
			'deselect'                                    => esc_html__( 'Deselect', 'bricks' ),
			'desktop'                                     => esc_html__( 'Desktop', 'bricks' ),
			'details'                                     => esc_html__( 'Details', 'bricks' ),
			'direction'                                   => esc_html__( 'Direction', 'bricks' ),
			'disable'                                     => esc_html__( 'Disable', 'bricks' ),
			'disabled'                                    => esc_html__( 'Disabled', 'bricks' ),
			'disableUrlParamsFilter'                      => esc_html__( 'Disable URL parameter filter', 'bricks' ),
			'disableUrlParamsFilterDesc'                  => esc_html__( 'No URL parameters are generated or read, even if filter elements are present.', 'bricks' ),
			'disableQueryMerge'                           => esc_html__( 'Disable query merge', 'bricks' ),
			'discard'                                     => esc_html__( 'Discard', 'bricks' ),
			'disconnect'                                  => esc_html__( 'Disconnect', 'bricks' ),
			'discarded'                                   => esc_html__( 'Discarded', 'bricks' ),
			'div'                                         => 'Div',
			'documentation'                               => esc_html__( 'Documentation', 'bricks' ),
			'dots'                                        => esc_html__( 'Dots', 'bricks' ),
			'dotted'                                      => esc_html__( 'Dotted', 'bricks' ),
			'double'                                      => esc_html__( 'double', 'bricks' ),
			'download'                                    => esc_html__( 'Download', 'bricks' ),
			'downloaded'                                  => esc_html__( 'Downloaded', 'bricks' ),
			'downloading'                                 => esc_html__( 'Downloading', 'bricks' ),
			'dropFilesJSON'                               => esc_html__( 'Drop file(s) here', 'bricks' ) . ' (JSON)',
			'dropFilesFont'                               => esc_html__( 'Drop file(s) here', 'bricks' ) . ' (WOFF, WOFF2, TTF)',
			'duplicate'                                   => esc_html__( 'Duplicate', 'bricks' ),
			'duplicateClassesDetected'                    => esc_html__( 'Duplicate classes detected', 'bricks' ),
			'duplicateClassesWarning'                     => esc_html__( 'Duplicate classes detected. Resolve conflicts before importing.', 'bricks' ),
			'duplicateFontVariation'                      => esc_html__( 'A font variation with this weight and style already exists.', 'bricks' ),
			'dynamicData'                                 => esc_html__( 'Dynamic data', 'bricks' ),
			'dynamicDataIsEmpty'                          => esc_html__( 'Dynamic data is empty.', 'bricks' ),
			'dynamicDataTag'                              => esc_html__( 'Dynamic data tag', 'bricks' ),

			'edit'                                        => esc_html__( 'Edit', 'bricks' ),
			'editIcon'                                    => esc_html__( 'Edit icon', 'bricks' ),
			'edited'                                      => esc_html__( 'Edited', 'bricks' ),
			'editComponent'                               => esc_html__( 'Edit component', 'bricks' ),
			'editTemplate'                                => esc_html__( 'Edit Template', 'bricks' ),
			'editColorPalette'                            => esc_html__( 'Edit palette', 'bricks' ),
			'editing'                                     => esc_html__( 'Editing', 'bricks' ),
			'editInWordPress'                             => esc_html__( 'Edit in WordPress', 'bricks' ),
			'effect'                                      => esc_html__( 'Effect', 'bricks' ),
			'element'                                     => esc_html__( 'Element', 'bricks' ),
			'elements'                                    => esc_html__( 'Elements', 'bricks' ),
			'elementManager'                              => esc_html__( 'Element Manager', 'bricks' ),
			'elementClasses'                              => esc_html__( 'Element classes', 'bricks' ),
			'elementId'                                   => esc_html__( 'Element ID', 'bricks' ),
			'ellipse'                                     => esc_html__( 'Ellipse', 'bricks' ),
			'equal'                                       => esc_html__( 'Equal', 'bricks' ),

			// x-template element placeholder text
			'elementPlaceholder'                          => [
				'default'               => esc_html__( 'No content', 'bricks' ),

				'accordion'             => esc_html__( 'No accordion item added.', 'bricks' ),
				'audio'                 => esc_html__( 'No audio file selected.', 'bricks' ),
				'code'                  => esc_html__( 'No code found.', 'bricks' ),
				'countdown'             => esc_html__( 'No date/fields set.', 'bricks' ),
				'facebook'              => esc_html__( 'No Facebook page URL provided.', 'bricks' ),
				'form'                  => esc_html__( 'No form field added.', 'bricks' ),
				'html'                  => esc_html__( 'No HTML markup defined.', 'bricks' ),
				'icon'                  => esc_html__( 'No icon selected.', 'bricks' ),
				'list'                  => esc_html__( 'No list items defined.', 'bricks' ),
				'map'                   => sprintf(
					// translators: %s: Link to Bricks Academy
					esc_html__( 'Google Maps API key required! Add key in dashboard under: %s', 'bricks' ),
					'<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" target="_blank">Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > API keys</a>'
				),
				'pricing-table'         => esc_html__( 'No pricing table defined.', 'bricks' ),
				'progress-bar'          => esc_html__( 'No progress bar created.', 'bricks' ),
				'slider'                => esc_html__( 'No slide added.', 'bricks' ),
				'social-icons'          => esc_html__( 'No icon selected.', 'bricks' ),
				'svg'                   => esc_html__( 'No SVG selected.', 'bricks' ),
				'tabs'                  => esc_html__( 'No tabs added.', 'bricks' ),
				'team-members'          => esc_html__( 'No team members added.', 'bricks' ),
				'template'              => esc_html__( 'No template selected.', 'bricks' ),
				'testimonials'          => esc_html__( 'No testimonials added.', 'bricks' ),
				'text'                  => esc_html__( 'No text added.', 'bricks' ),
				'videoNoFileUrl'        => esc_html__( 'No file URL provided.', 'bricks' ),
				'videoNoVideo'          => esc_html__( 'No video selected.', 'bricks' ),
				'videoNoYoutubeId'      => esc_html__( 'No YouTube URL provided.', 'bricks' ),
				'videoNoVimeoId'        => esc_html__( 'No Vimeo URL provided.', 'bricks' ),
				'videoNoDynamicData'    => esc_html__( 'No dynamic data set.', 'bricks' ),
				'videoDynamicDataEmpty' => esc_html__( 'The dynamic data is empty.', 'bricks' ),
			],

			'emailAddress'                                => esc_html__( 'Email address', 'bricks' ),
			'end'                                         => esc_html__( 'End', 'bricks' ),
			'endTime'                                     => esc_html__( 'End time', 'bricks' ),
			'error'                                       => esc_html__( 'Error', 'bricks' ),
			'errorBricksAcademy404'                       => esc_html__( 'Articles could not be loaded. Please visit the official knowledge base:', 'bricks' ),
			'errorPage'                                   => esc_html__( '404 Error Page', 'bricks' ),
			'errorCreatingClass'                          => esc_html__( 'Class found in trash', 'bricks' ),
			'errorDeletingClass'                          => esc_html__( 'Error deleting class', 'bricks' ),
			'errorDeletingClasses'                        => esc_html__( 'Error deleting class', 'bricks' ),
			'errorFetchingSiteClasses'                    => esc_html__( 'Error fetching site classes', 'bricks' ),
			'errorGeneratingCodeSignature'                => esc_html__( 'Code signatures are locked.', 'bricks' ),
			'errorRestoringClass'                         => esc_html__( 'Error restoring class', 'bricks' ),
			'errorOnSave'                                 => esc_html__( 'Error on save', 'bricks' ),
			'excerptLength'                               => esc_html__( 'Excerpt length', 'bricks' ),
			'exclude'                                     => esc_html__( 'Exclude', 'bricks' ),
			'excludeCurrent'                              => esc_html__( 'Exclude current post', 'bricks' ),
			'executeCode'                                 => esc_html__( 'Execute code', 'bricks' ),
			'expand'                                      => esc_html__( 'Expand', 'bricks' ),
			'expandAll'                                   => esc_html__( 'Expand all', 'bricks' ),
			'experimental'                                => esc_html__( 'experimental', 'bricks' ),
			'export'                                      => esc_html__( 'Export', 'bricks' ),
			'exportSelected'                              => esc_html__( 'Export selected', 'bricks' ),
			'exportVariables'                             => esc_html__( 'Export Variables', 'bricks' ),
			'extraLarge'                                  => esc_html__( 'Extra large', 'bricks' ),
			'extraSmall'                                  => esc_html__( 'Extra small', 'bricks' ),

			'fade'                                        => esc_html__( 'Fade', 'bricks' ),
			'farthestSide'                                => esc_html__( 'Farthest side', 'bricks' ),
			'farthestCorner'                              => esc_html__( 'Farthest corner', 'bricks' ),
			'fallbackFont'                                => esc_html__( 'Fallback fonts', 'bricks' ),
			'false'                                       => esc_html__( 'False', 'bricks' ),
			'favorites'                                   => esc_html__( 'Favorites', 'bricks' ),
			'featured'                                    => esc_html__( 'Featured', 'bricks' ),
			'field'                                       => esc_html__( 'Field', 'bricks' ),
			'file'                                        => esc_html__( 'File', 'bricks' ),
			'fileImported'                                => esc_html__( '"%s" imported.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileNotImportedAlreadyExists'                => esc_html__( 'Import of "%s" failed: Name already exists.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileNotImportedWrongFormat'                  => esc_html__( 'Import of "%s" failed: Wrong format.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileUrl'                                     => esc_html__( 'File URL', 'bricks' ),
			'files'                                       => esc_html__( 'Files', 'bricks' ),
			'fill'                                        => esc_html__( 'Fill', 'bricks' ),
			'fillGrid'                                    => esc_html__( 'Fill grid', 'bricks' ),
			'filter'                                      => esc_html__( 'Filter', 'bricks' ),
			'fillDark'                                    => esc_html__( 'Fill - Dark', 'bricks' ),
			'fillLight'                                   => esc_html__( 'Fill - Light', 'bricks' ),
			'fillPrimary'                                 => esc_html__( 'Fill - Primary', 'bricks' ),
			'find'                                        => esc_html__( 'Find', 'bricks' ),
			'finish'                                      => esc_html__( 'Finish', 'bricks' ),
			'fixed'                                       => esc_html__( 'Fixed', 'bricks' ),
			'fontDeletedPermanentlyConfirm'               => esc_html__( 'Are you sure you want to delete this font and all of its font variation files?', 'bricks' ),
			'fontDeletedPermanently'                      => esc_html__( 'Font deleted permanently', 'bricks' ),
			'fontFamily'                                  => esc_html__( 'Font family', 'bricks' ),
			'fontFamilyPlaceholder'                       => esc_html__( 'Font name', 'bricks' ),
			'fontFileSelected'                            => esc_html__( 'Font file selected', 'bricks' ),
			'fontDownloaded'                              => esc_html__( 'Font downloaded', 'bricks' ) . ' (' . esc_html__( 'Custom fonts', 'bricks' ) . ')',
			'fontDownloadFailed'                          => esc_html__( 'Font download failed', 'bricks' ),
			'fontManager'                                 => esc_html__( 'Font manager', 'bricks' ),
			'fontPreviewTextCustom'                       => esc_html__( 'Custom preview text', 'bricks' ),
			'fontRestored'                                => esc_html__( 'Font restored', 'bricks' ),
			'fontRestoreError'                            => esc_html__( 'Font restore error', 'bricks' ),
			'fontSize'                                    => esc_html__( 'Font size', 'bricks' ),
			'fontStyle'                                   => esc_html__( 'Font style', 'bricks' ),
			'fontWeight'                                  => esc_html__( 'Font weight', 'bricks' ),
			// translators: %s: Link to Bricks settings
			'fontFavoritesDescription'                    => sprintf(
				esc_html__( 'By default, the favorite fonts are listed first in the font-family options. To show only the favorite fonts, select "Show favorites only" at %s.', 'bricks' ),
				'<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-builder' ) . '" target="_blank">Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > ' . esc_html__( 'Builder', 'bricks' ) . ' > ' . esc_html__( 'Font Family', 'bricks' ) . ': ' . esc_html__( 'Options', 'bricks' ) . '</a>'
			),
			'fontMovedToTrash'                            => esc_html__( 'Font moved to trash', 'bricks' ),
			'fontVariants'                                => esc_html__( 'Font variants', 'bricks' ),
			'fontVariations'                              => esc_html__( 'Font variations', 'bricks' ),
			'fontVariationNoFile'                         => esc_html__( 'Select/upload font variation', 'bricks' ),
			'fontVariationSettings'                       => esc_html__( 'Font variation settings', 'bricks' ),
			'fonts'                                       => esc_html__( 'Fonts', 'bricks' ),
			'fontsAdobe'                                  => esc_html__( 'Adobe fonts', 'bricks' ),
			'fontsCustom'                                 => esc_html__( 'Custom fonts', 'bricks' ),
			'fontsGoogle'                                 => esc_html__( 'Google fonts', 'bricks' ),
			'fontsStandard'                               => esc_html__( 'Standard fonts', 'bricks' ),
			'footer'                                      => esc_html__( 'Footer', 'bricks' ),
			'frontend'                                    => esc_html__( 'Frontend', 'bricks' ),
			'fullSize'                                    => esc_html__( 'Full size', 'bricks' ),
			'fullScreen'                                  => esc_html__( 'Fullscreen', 'bricks' ),

			'galleryLayout'                               => esc_html__( 'Gallery layout', 'bricks' ),
			'gap'                                         => esc_html__( 'Gap', 'bricks' ),
			'general'                                     => esc_html__( 'General', 'bricks' ),
			'generateScreenshots'                         => esc_html__( 'Generate screenshots', 'bricks' ),
			'generatingScreenshots'                       => esc_html__( 'Generating screenshots' ),
			'ghostDark'                                   => esc_html__( 'Outline - Dark', 'bricks' ),
			'ghostLight'                                  => esc_html__( 'Outline - Light', 'bricks' ),
			'ghostPrimary'                                => esc_html__( 'Outline - Primary', 'bricks' ),
			'global'                                      => esc_html__( 'Global', 'bricks' ),
			'globalElement'                               => esc_html__( 'Global element', 'bricks' ),
			'globalElements'                              => esc_html__( 'Global elements', 'bricks' ),
			'globalElementDeprecatedInfo'                 => sprintf(
				esc_html__( 'Global elements are deprecated since version 2.0 and will be removed in the near future. Please convert them into components as soon as possible under %s. Once done, please delete all global elements by hovering over a global element below and clicking the "Delete" icon.', 'bricks' ),
				'<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > ' . esc_html__( 'General', 'bricks' ) . ' > ' . esc_html__( 'Convert', 'bricks' ) . '</a>'
			),
			'globalClass'                                 => esc_html__( 'Global class', 'bricks' ),
			'globalClasses'                               => esc_html__( 'Global classes', 'bricks' ),
			'globalClassManagerImportSettings'            => '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-builder' ) . '" target="_blank">Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > ' . esc_html__( 'Builder', 'bricks' ) . ' > ' . esc_html__( 'Global class import manager', 'bricks' ) . '</a>',
			'globalClassManagerInfoBulk'                  => esc_html__( 'Press CMD/CTRL or SHIFT to select and edit multiple categories or classes.', 'bricks' ),
			'globalClassManagerInfoCategory'              => esc_html__( 'Select one or multiple categories to filter your classes by them.', 'bricks' ),
			'globalClassManagerInfoCategorize'            => esc_html__( 'Categorize classes by dragging them into a specific category or into "Uncategorize" to uncategorize them.', 'bricks' ),
			'globalClassManagerInfoImport'                => esc_html__( 'Once you have reviewed all classes and resolved all conflicts, click the "Import" button at the top to import the classes into your site.', 'bricks' ),
			'globalClassManagerInfoClass'                 => esc_html__( 'Select one or multiple classes to edit them.', 'bricks' ),
			'globalClassManagerInfoOrder'                 => esc_html__( 'Drag any category or class up/down to order it.', 'bricks' ),
			'globalClassManagerInfoTitle'                 => esc_html__( 'How to use the global class manager', 'bricks' ),
			'globalClassManagerImportInfoTitle'           => esc_html__( 'How to use the class importer', 'bricks' ),
			'globalClassManagerSearchInfo'                => esc_html__( 'Prefix with a dot to search for classes starting with the string, or suffix with a dot to search for classes ending with the string.', 'bricks' ),
			'globalClassManagerImportSearchInfo'          => esc_html__( 'Prefix with a dot to search for imported classes starting with the string, or suffix with a dot to search for imported classes ending with the string.', 'bricks' ),
			'globalClassesImported'                       => esc_html__( 'Global classes imported', 'bricks' ),
			'globalClassesEmptyDescription'               => esc_html__( 'Enter the name of your first global CSS class in the field above. Then hit enter to create it.', 'bricks' ) . ' (' . Helpers::article_link( 'global-css-classes', esc_html__( 'Learn more', 'bricks' ) ) . ')',
			'globalVariableManagerImportTextarea'         => esc_html__( 'Enter CSS variable definitions separated by semicolon', 'bricks' ),
			'globalVariableManagerInfoTitle'              => esc_html__( 'How to use the global variable manager', 'bricks' ),
			'globalVariableManagerColorEditTitle'         => esc_html__( 'Color editor', 'bricks' ),
			'globalVariableManagerInfoCategory'           => esc_html__( 'Select one or multiple categories to filter your variables by them.', 'bricks' ),
			'globalVariableManagerInfoVariable'           => esc_html__( 'Select one or multiple variables to edit them.', 'bricks' ),
			'globalVariableManagerInfoBulk'               => esc_html__( 'Press CMD/CTRL or SHIFT to select and edit multiple categories or variables.', 'bricks' ),
			'globalVariableManagerInfoOrder'              => esc_html__( 'Drag any category or variable up/down to order it.', 'bricks' ),
			'globalVariableManagerInfoCategorize'         => esc_html__( 'Categorize variables by dragging them into a specific category or into "Uncategorize" to uncategorize them.', 'bricks' ),
			'globalVariableManagerNothingFound'           => esc_html__( 'No variables found. Create a CSS variable using the input at the bottom or in bulk by clicking the "Import" icon at the top.', 'bricks' ),
			'globalVariableManagerRenameNotice'           => esc_html__( 'Renaming a CSS variable does not automatically update its instances in your site.', 'bricks' ),
			'globalVariableManagerSearchInfo'             => esc_html__( 'Prefix with a dot to search for variables starting with the string, or suffix with a dot to search for variables ending with the string.', 'bricks' ),
			'googleFontsDisabled'                         => esc_html__( 'Google fonts have been disabled', 'bricks' ) . ': Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > ' . esc_html__( 'Performance', 'bricks' ),
			'gradient'                                    => esc_html__( 'Gradient', 'bricks' ),
			// translators: %s: Color stop, %s: Colors
			'gradientRepeatInfo'                          => sprintf(
				esc_html__( 'Make sure to set "%1$s" in your "%2$s" definitions below.', 'bricks' ),
				esc_html__( 'Color stop', 'bricks' ),
				esc_html__( 'Colors', 'bricks' )
			),
			'groups'                                      => esc_html__( 'Groups', 'bricks' ),
			'group'                                       => esc_html__( 'Group', 'bricks' ),
			'groupAlreadyExists'                          => esc_html__( 'Group already exists', 'bricks' ),
			'gardientColorsDescription'                   => esc_html__( 'Add at least two colors to create a gradient.', 'bricks' ),
			'goToSettingsPanel'                           => esc_html__( 'Back to settings', 'bricks' ),
			'gotIt'                                       => esc_html__( 'Got it', 'bricks' ),
			'goTo'                                        => esc_html__( 'Go to', 'bricks' ),
			'grid'                                        => esc_html__( 'Grid', 'bricks' ),
			'gridItem'                                    => esc_html__( 'Grid item', 'bricks' ),
			'gutter'                                      => esc_html__( 'Spacing', 'bricks' ),

			'hasConflict'                                 => esc_html__( 'Has conflict', 'bricks' ),
			'hasInheritedSettings'                        => esc_html__( 'Has inherited settings', 'bricks' ),
			'hasStyles'                                   => esc_html__( 'Has styles', 'bricks' ),
			'hasNoStyles'                                 => esc_html__( 'Has no styles', 'bricks' ),
			'header'                                      => esc_html__( 'Header', 'bricks' ),
			'height'                                      => esc_html__( 'Height', 'bricks' ),
			'help'                                        => esc_html__( 'Help', 'bricks' ),
			'hide'                                        => esc_html__( 'Hide', 'bricks' ),
			'hideElement'                                 => esc_html__( 'Hide element', 'bricks' ),
			'hideElementBuilderDesc'                      => esc_html__( 'Enable to not load/render this element in the builder.', 'bricks' ),
			'hideElementFrontendDesc'                     => esc_html__( 'Enable to not load/render this element on the frontend.', 'bricks' ),
			'hidden'                                      => esc_html__( 'Hidden', 'bricks' ),
			'hideInfo'                                    => esc_html__( 'Hide info', 'bricks' ),
			'hideOutOfStock'                              => esc_html__( 'Hide out of stock', 'bricks' ),
			'history'                                     => esc_html__( 'History', 'bricks' ),
			'historyDeleted'                              => esc_html__( 'History deleted', 'bricks' ),
			'home'                                        => esc_html__( 'Home', 'bricks' ),
			'homePage'                                    => esc_html__( 'Home page', 'bricks' ),
			'horizontal'                                  => esc_html__( 'Horizontal', 'bricks' ),
			'howToCreateHeaderTemplate'                   => esc_html__( 'How to create a header template', 'bricks' ),
			'howToCreateFooterTemplate'                   => esc_html__( 'How to create a footer template', 'bricks' ),
			'html5AudioNoBrowserSupport'                  => esc_html__( 'Your browser does not support the audio tag.', 'bricks' ),
			'html5VideoNoBrowserSupport'                  => esc_html__( 'Your browser does not support the video tag.', 'bricks' ),
			'hue'                                         => esc_html__( 'Hue', 'bricks' ),

			'icon'                                        => esc_html__( 'Icon', 'bricks' ),
			'icons'                                       => esc_html__( 'Icons', 'bricks' ),
			'iconManager'                                 => esc_html__( 'Icon manager', 'bricks' ),
			'iconSet'                                     => esc_html__( 'Icon set', 'bricks' ),
			'iconsDeleted'                                => esc_html__( 'Icon(s) deleted successfully', 'bricks' ),
			'iconSetDisabledInfo'                         => esc_html__( 'This icon set is currently disabled and hidden from the icon dropdown menu. However, any existing icons from this set will still display on your site.', 'bricks' ),
			'iconSource'                                  => esc_html__( 'Icon source', 'bricks' ),
			'iconRemoveConfirmation'                      => esc_html__( 'Are you sure you want to remove this icon?', 'bricks' ),
			'iconsImported'                               => esc_html__( 'Icon(s) imported successfully', 'bricks' ),
			'ignoreStickyPosts'                           => esc_html__( 'Ignore sticky posts', 'bricks' ),
			'image'                                       => esc_html__( 'Image', 'bricks' ),
			'imageGallery'                                => esc_html__( 'Image gallery', 'bricks' ),
			'imageGalleryDescription'                     => esc_html__( 'Hold down CMD/CRTL to select multiple images.', 'bricks' ),
			'imageNotFound'                               => esc_html__( 'Image not found', 'bricks' ),
			'imageSize'                                   => esc_html__( 'Image size', 'bricks' ),
			'import'                                      => esc_html__( 'Import', 'bricks' ),
			'imported'                                    => esc_html__( 'Imported', 'bricks' ),
			'importClasses'                               => esc_html__( 'Import classes', 'bricks' ),
			'importClassesSkip'                           => esc_html__( 'Skip class import', 'bricks' ),
			'importClassesInfo'                           => esc_html__( 'New classes detected. Resolve conflicts, if any, to import or skip.', 'bricks' ),
			'importClassConflictById'                     => esc_html__( 'A class with the same internal ID, but different settings, already exists on this site. You must either override the existing class on your site or discard this imported version.', 'bricks' ),
			'importClassConflictByName'                   => esc_html__( 'A class with the same name, but different settings, already exists on this site. You must either override the existing class on your site or discard this imported version.', 'bricks' ),
			'importClassesConflict'                       => esc_html__( 'One or more of the selected classes conflict with existing classes on your site. You must either override the existing classes on your site or discard these imported versions.', 'bricks' ),
			'importClassesResolveConflicts'               => esc_html__( 'Resolve all conflicts listed below, highlighted in red, to continue with importing those classes.', 'bricks' ),
			'importCssVariables'                          => esc_html__( 'Import CSS variables', 'bricks' ),
			'importImages'                                => esc_html__( 'Import images', 'bricks' ),
			'importImagesDisabled'                        => esc_html__( 'Disabled: Show placeholder images.', 'bricks' ),
			'importImagesEnabled'                         => esc_html__( 'Enabled: Download template images to media library.', 'bricks' ),
			'imports'                                     => esc_html__( 'Imports', 'bricks' ),
			'importTemplateDragAndDrop'                   => esc_html__( 'Drag and drop .JSON or .ZIP template file(s) in here ..', 'bricks' ),
			'importTemplate'                              => esc_html__( 'Import template', 'bricks' ),
			'importNote'                                  => esc_html__( 'Valid JSON data required to run the importer', 'bricks' ),
			'importTemplateColorPalette'                  => esc_html__( 'This template contains a color palette. Would you like to import it?', 'bricks' ),
			'importTemplateColorPalettes'                 => esc_html__( 'This template contains color palettes. Would you like to import them?', 'bricks' ),
			'importTemplateGlobalVariables'               => esc_html__( 'This template contains global variables. Would you like to import them?', 'bricks' ),
			'importTemplateThemeStyles'                   => esc_html__( 'This template contains the following theme styles. Would you like to import them?', 'bricks' ),
			'include'                                     => esc_html__( 'Include', 'bricks' ),
			'includeChildren'                             => esc_html__( 'Include children', 'bricks' ),
			'incoming'                                    => esc_html__( 'Incoming', 'bricks' ),
			'incomingChanges'                             => esc_html__( 'Incoming changes', 'bricks' ),
			'index'                                       => esc_html__( 'Index', 'bricks' ),
			'infinite'                                    => esc_html__( 'Infinite', 'bricks' ),
			'infiniteScroll'                              => esc_html__( 'Infinite scroll', 'bricks' ),
			'info'                                        => esc_html__( 'Info', 'bricks' ),
			'infoElementDisabled'                         => esc_html__( 'Element has been disabled globally.', 'bricks' ),
			'infoElementNotFound'                         => esc_html__( 'Element doesn\'t exist.', 'bricks' ),
			'infoLightbox'                                => esc_html__( 'Customize lightbox: Settings > Theme Styles > General', 'bricks' ),
			'infoAccessRequired'                          => esc_html__( 'Your builder capability doesn\'t allow you to access these settings.', 'bricks' ),
			'inheritedFrom'                               => esc_html__( 'Inherited from', 'bricks' ),
			'innerContainer'                              => esc_html__( 'Inner container', 'bricks' ),
			'insert'                                      => esc_html__( 'Insert', 'bricks' ),
			'inserted'                                    => esc_html__( 'Inserted', 'bricks' ),
			'insertAfter'                                 => esc_html__( 'Insert after', 'bricks' ),
			'insertMedia'                                 => esc_html__( 'Insert media', 'bricks' ),
			'insertLayout'                                => esc_html__( 'Insert layout', 'bricks' ),
			'insertSection'                               => esc_html__( 'Insert section', 'bricks' ),
			'insertTemplate'                              => esc_html__( 'Insert template', 'bricks' ),
			'insertSameComponentError'                    => esc_html__( 'Insert of the same component is not possible.', 'bricks' ),
			'inset'                                       => esc_html__( 'Inset', 'bricks' ),
			'instance'                                    => esc_html__( 'Instance', 'bricks' ),
			'instances'                                   => esc_html__( 'Instances', 'bricks' ),
			'interactionId'                               => esc_html__( 'Interaction ID', 'bricks' ),
			'interactions'                                => esc_html__( 'Interactions', 'bricks' ),
			'internal'                                    => esc_html__( 'Internal post/page', 'bricks' ),
			'invalidSvgFiles'                             => esc_html__( 'Invalid SVG files', 'bricks' ),
			'invert'                                      => esc_html__( 'Invert', 'bricks' ),
			'isArchiveMainQuery'                          => esc_html__( 'Is main query', 'bricks' ),
			'isArchiveMainQueryDescription'               => esc_html__( 'Enable if your archive pagination is not working.', 'bricks' ),
			'italic'                                      => esc_html__( 'Italic', 'bricks' ),
			'item'                                        => esc_html__( 'Item', 'bricks' ),

			'joinUs'                                      => esc_html__( 'Join Us', 'bricks' ),
			'justify'                                     => esc_html__( 'Justify', 'bricks' ),
			'justifyContent'                              => esc_html__( 'Justify content', 'bricks' ),

			'key'                                         => esc_html__( 'Key', 'bricks' ),
			'keyboardShortcuts'                           => esc_html__( 'Keyboard shortcuts', 'bricks' ),

			'label'                                       => esc_html__( 'Label', 'bricks' ),
			'language'                                    => esc_html__( 'Language', 'bricks' ),
			'large'                                       => esc_html__( 'Large', 'bricks' ),
			'laptop'                                      => esc_html__( 'Laptop', 'bricks' ),
			'lastRefresh'                                 => esc_html__( 'Last refresh', 'bricks' ),
			'latest'                                      => esc_html__( 'Latest', 'bricks' ),
			'layout'                                      => esc_html__( 'Layout', 'bricks' ),
			'learnMore'                                   => esc_html__( 'Learn more', 'bricks' ),
			'left'                                        => esc_html__( 'Left', 'bricks' ),
			'letterSpacing'                               => esc_html__( 'Letter spacing', 'bricks' ),
			'lightboxAnimation'                           => esc_html__( 'Lightbox', 'bricks' ) . ': ' . esc_html__( 'Animation', 'bricks' ),
			'lightboxId'                                  => esc_html__( 'Lightbox ID', 'bricks' ),
			'lightboxImage'                               => esc_html__( 'Lightbox Image', 'bricks' ),
			'lightboxVideo'                               => esc_html__( 'Lightbox Video', 'bricks' ),
			'lightness'                                   => esc_html__( 'Lightness', 'bricks' ),
			'lineHeight'                                  => esc_html__( 'Line height', 'bricks' ),
			'link'                                        => esc_html__( 'Link', 'bricks' ),
			'linear'                                      => esc_html__( 'Linear', 'bricks' ),
			'linked'                                      => esc_html__( 'Linked', 'bricks' ),
			'list'                                        => esc_html__( 'List', 'bricks' ),
			'liveSearch'                                  => esc_html__( 'Live search', 'bricks' ),
			'liveSearchDescription'                       => esc_html__( 'When enabled, this query only runs when a live search is performed.', 'bricks' ),
			'liveSearchInfo'                              => esc_html__( 'Provide the element ID that holds the live search results below.', 'bricks' ),
			'liveSearchWrapperSelector'                   => esc_html__( 'Live search results', 'bricks' ),
			'liveSearchWrapperSelectorDesc'               => esc_html__( 'Element ID that holds the live search results. Only visible when the live search is performed.', 'bricks' ),
			'loadingTemplates'                            => esc_html__( 'Loading templates', 'bricks' ),
			'loadingFontData'                             => esc_html__( 'Loading font data', 'bricks' ),
			'loadMore'                                    => esc_html__( 'Load more', 'bricks' ),
			'lock'                                        => esc_html__( 'Lock', 'bricks' ),
			'lockSelected'                                => esc_html__( 'Lock selected', 'bricks' ),
			'locked'                                      => esc_html__( 'Locked', 'bricks' ),
			'lockedUserGoBack'                            => esc_html__( 'Go back', 'bricks' ),
			'lockedUserTakeOver'                          => esc_html__( 'Take over', 'bricks' ),
			'lockedUserTitle'                             => esc_html__( 'This post is already being edited.', 'bricks' ),
			'lockedUserText'                              => esc_html__( '%s is currently working on this post, which means you cannot make changes, unless you take over.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'login'                                       => esc_html__( 'Login', 'bricks' ),
			'loop'                                        => esc_html__( 'Loop', 'bricks' ),
			'lowercase'                                   => esc_html__( 'Lowercase', 'bricks' ),

			'linkStates'                                  => [
				'unlinked'  => esc_html__( 'Unlinked', 'bricks' ),
				'opposites' => esc_html__( 'Opposites linked', 'bricks' ),
				'all'       => esc_html__( 'All sides linked', 'bricks' ),
			],

			'main'                                        => esc_html__( 'Main', 'bricks' ),
			'mainQuery'                                   => esc_html__( 'Main query', 'bricks' ),
			'manage'                                      => esc_html__( 'Manage', 'bricks' ),
			'margin'                                      => esc_html__( 'Margin', 'bricks' ),
			'markAllAsRead'                               => esc_html__( 'Mark all as read', 'bricks' ),
			'masonry'                                     => 'Masonry',

			// translators: %s: Max upload size
			'maxUploadSizeInfo'                           => sprintf( esc_html__( 'Max upload size: %s', 'bricks' ), size_format( wp_max_upload_size() ) ),
			'media'                                       => esc_html__( 'Media', 'bricks' ),
			'metaKey'                                     => esc_html__( 'Meta key', 'bricks' ),
			'metaKeyOrder'                                => esc_html__( 'Order meta key', 'bricks' ),
			'metaValue'                                   => esc_html__( 'Meta value', 'bricks' ),
			'metaValueNum'                                => esc_html__( 'Numeric meta value', 'bricks' ),
			'metaQuery'                                   => esc_html__( 'Meta query', 'bricks' ),
			'menuOrder'                                   => esc_html__( 'Menu order', 'bricks' ),
			'metro'                                       => 'Metro',
			'mimeType'                                    => esc_html__( 'Mime type', 'bricks' ),
			'mimeTypeDesc'                                => Helpers::article_link( 'query-loop/#media-query', esc_html__( 'Filter media by mime type', 'bricks' ) ),
			'mobile'                                      => esc_html__( 'Mobile', 'bricks' ),
			'mobileFirst'                                 => esc_html__( 'Mobile first', 'bricks' ),
			'mode'                                        => esc_html__( 'Mode', 'bricks' ),
			'modified'                                    => esc_html__( 'Modified', 'bricks' ),
			'modifiedDate'                                => esc_html__( 'Modified date', 'bricks' ),
			'months'                                      => [
				esc_html__( 'January', 'bricks' ),
				esc_html__( 'February', 'bricks' ),
				esc_html__( 'March', 'bricks' ),
				esc_html__( 'April', 'bricks' ),
				esc_html__( 'May', 'bricks' ),
				esc_html__( 'June', 'bricks' ),
				esc_html__( 'July', 'bricks' ),
				esc_html__( 'August', 'bricks' ),
				esc_html__( 'September', 'bricks' ),
				esc_html__( 'October', 'bricks' ),
				esc_html__( 'November', 'bricks' ),
				esc_html__( 'December', 'bricks' ),
			],
			'moreLayouts'                                 => esc_html__( 'More layouts', 'bricks' ),
			'mostPopular'                                 => esc_html__( 'Most Popular', 'bricks' ),
			'move'                                        => esc_html__( 'Move', 'bricks' ),
			'moveSelected'                                => esc_html__( 'Move selected', 'bricks' ),
			'moved'                                       => esc_html__( 'Moved', 'bricks' ),
			'moveToTrash'                                 => esc_html__( 'Move to trash', 'bricks' ),
			'movedToTrash'                                => esc_html__( 'Moved to trash', 'bricks' ),
			'multipleOptions'                             => esc_html__( 'Multiple options', 'bricks' ),
			'myTemplates'                                 => esc_html__( 'My templates', 'bricks' ),
			'myAccount'                                   => esc_html__( 'My account', 'bricks' ),

			'name'                                        => esc_html__( 'Name', 'bricks' ),
			'new'                                         => esc_html__( 'New', 'bricks' ),
			'newColorPalette'                             => esc_html__( 'New color palette name', 'bricks' ),
			'newColorPaletteCreateFirstColor'             => esc_html__( 'Add your first color to this palette by selecting a color value above and then click "Save".', 'bricks' ),
			'newGroupName'                                => esc_html__( 'New group name', 'bricks' ),
			'newTab'                                      => esc_html__( 'New tab', 'bricks' ),
			'newImageName'                                => esc_html__( 'Type name, hit enter', 'bricks' ),
			'next'                                        => esc_html__( 'Next', 'bricks' ),
			'noActiveSet'                                 => esc_html__( 'No active icon set selected', 'bricks' ),
			'noClassesToImport'                           => esc_html__( 'No classes to import.', 'bricks' ),
			'noComponentsFound'                           => esc_html__( 'No components found.', 'bricks' ),
			'noConditionsSet'                             => esc_html__( 'Click the "+" icon to add your first condition.', 'bricks' ) . ' <strong>' . esc_html__( 'Conditions don\'t run in the builder.', 'bricks' ) . '</strong>',
			'noInteractionsSet'                           => esc_html__( 'Click the "+" icon to add your first interaction.', 'bricks' ) . ' <strong>' . esc_html__( 'Interactions don\'t run in the builder.', 'bricks' ) . '</strong>',
			'noContent'                                   => esc_html__( 'No content', 'bricks' ),
			'noFileSelected'                              => esc_html__( 'No file selected.', 'bricks' ),
			'noInstances'                                 => esc_html__( 'No instances', 'bricks' ),
			'noPropertiesConnected'                       => esc_html__( 'No properties connected.', 'bricks' ),
			'noConnectablePropertyFound'                  => esc_html__( 'No connectable property found.', 'bricks' ),
			'noPropertiesConnectedDesc'                   => esc_html__( 'Properties found, but none are conneted to any setting of your main component.', 'bricks' ),
			'noPropertiesDesc'                            => esc_html__( 'Create properties and connect them to your component settings to customize a component instance.', 'bricks' ),
			'noPropertiesFound'                           => esc_html__( 'No properties found.', 'bricks' ),
			'noPropertyGroupsFound'                       => esc_html__( 'No property groups found.', 'bricks' ),
			'no'                                          => esc_html__( 'No', 'bricks' ),
			'noConflict'                                  => esc_html__( 'No conflict', 'bricks' ),
			'noDefaultValue'                              => esc_html__( 'No default value', 'bricks' ),
			'none'                                        => esc_html__( 'None', 'bricks' ),
			'noRepeat'                                    => esc_html__( 'No-repeat', 'bricks' ),
			'noResults'                                   => esc_html__( 'No results', 'bricks' ),
			'noResultsDescription'                        => esc_html__( 'Select a template or provide a custom text to show if this query doesn\'t return any results.', 'bricks' ),
			'noPermission'                                => esc_html__( 'No permission', 'bricks' ),
			'normal'                                      => esc_html__( 'Normal', 'bricks' ),
			'noVariablesFound'                            => esc_html__( 'No CSS variable found.', 'bricks' ),
			'noDynamicDataFound'                          => esc_html__( 'No dynamic data found.', 'bricks' ),
			'noTemplatesFound'                            => esc_html__( 'No templates found.', 'bricks' ),
			'notFound'                                    => esc_html__( 'Not found', 'bricks' ),
			'nothingFound'                                => esc_html__( 'Nothing found.', 'bricks' ),
			'nothingFoundKeyword'                         => esc_html__( 'Nothing found. Please try again with a different keyword!', 'bricks' ),
			'nothingToCopy'                               => esc_html__( 'Nothing to copy', 'bricks' ),
			'nothingToPaste'                              => esc_html__( 'Nothing to paste', 'bricks' ),
			'notifications'                               => [
				'title'           => esc_html__( 'Notifications', 'bricks' ),
				'autosave'        => [
					'button'      => esc_html__( 'Preview autosave', 'bricks' ),
					'description' => esc_html__( 'There is an autosave more recent than the version you are currently viewing.', 'bricks' ),
				],
				'svg'             => [
					'description' => esc_html__( 'SVG files not imported for security reasons.', 'bricks' ),
				],
				'templateBundle'  => [
					'button'      => esc_html__( 'Set template style', 'bricks' ),
					'description' => esc_html__( 'Inserted template uses theme style "%s"', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
				],
				'populateContent' => [
					'button'      => esc_html__( 'Change content', 'bricks' ),
					'description' => esc_html__( 'Currently previewing content from "%s".', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
				]
			],
			'number'                                      => esc_html__( 'Number', 'bricks' ),
			'numberedlist'                                => esc_html__( 'Numbered list', 'bricks' ),

			'offset'                                      => esc_html__( 'Offset', 'bricks' ),
			'onSale'                                      => esc_html__( 'On sale', 'bricks' ),
			'opacity'                                     => esc_html__( 'Opacity', 'bricks' ),
			'open'                                        => esc_html__( 'Open', 'bricks' ),
			'openInNewTab'                                => esc_html__( 'Open in new tab', 'bricks' ),
			'openIconManager'                             => esc_html__( 'Open icon manager', 'bricks' ),
			'optional'                                    => esc_html__( 'Optional', 'bricks' ),
			'option'                                      => esc_html__( 'Option', 'bricks' ),
			'options'                                     => esc_html__( 'Options', 'bricks' ),
			'or'                                          => esc_html__( 'Or', 'bricks' ),
			'order'                                       => esc_html__( 'Order', 'bricks' ),
			'orderBy'                                     => esc_html__( 'Order by', 'bricks' ),
			// translators: %s: Number of orphaned elements
			'orphanedElementsDetected'                    => esc_html__( 'Orphaned elements detected (%s). Please back-up your site or at least copy all elements in the structure panel, then click the "Clean up" button below to remove all orphaned elements.', 'bricks' ) . ' ' . Helpers::article_link( 'known-issues/#orphaned-elements', esc_html__( 'Learn more', 'bricks' ) ),
			'orphanedElementsRemoved'                     => esc_html__( 'Orphaned elements removed.', 'bricks' ),
			'otherClasses'                                => esc_html__( 'Other classes', 'bricks' ),
			'otherPages'                                  => esc_html__( 'Other pages', 'bricks' ),
			'otherStyles'                                 => esc_html__( 'Other styles', 'bricks' ),
			'overlay'                                     => esc_html__( 'Overlay', 'bricks' ),
			'overline'                                    => esc_html__( 'Overline', 'bricks' ),
			'override'                                    => esc_html__( 'Override', 'bricks' ),
			'overrideLocalClass'                          => esc_html__( 'Override local class', 'bricks' ),
			'overwrite'                                   => esc_html__( 'Overwrite', 'bricks' ),

			'padding'                                     => esc_html__( 'Padding', 'bricks' ),
			'page'                                        => esc_html__( 'Page', 'bricks' ),
			'pages'                                       => esc_html__( 'Pages', 'bricks' ),
			'pageSettings'                                => esc_html__( 'Page settings', 'bricks' ),
			'panelRevisionsInfo'                          => esc_html__( 'Select any revision to preview it. Click "Apply" to continue editing the selected revision. Click "Discard" to continue editing the current revision.', 'bricks' ),
			'parent'                                      => esc_html__( 'Parent', 'bricks' ),
			'postParentId'                                => esc_html__( 'Insert post parent ID', 'bricks' ),
			'paste'                                       => esc_html__( 'Paste', 'bricks' ),
			'pasted'                                      => esc_html__( 'Pasted', 'bricks' ),
			'paused'                                      => esc_html__( 'Paused', 'bricks' ),
			'pin'                                         => esc_html__( 'Pin', 'bricks' ),
			'pinned'                                      => esc_html__( 'Pinned', 'bricks' ),
			'pinnedElements'                              => esc_html__( 'Pinned elements', 'bricks' ),
			'placeholder'                                 => esc_html__( 'Placeholder', 'bricks' ),
			'placeholderEmptyCanvas'                      => esc_html__( 'Click on any element to add it to your canvas.', 'bricks' ),
			'placeholderEmptyPopup'                       => esc_html__( 'Click on any element to add it to your popup.', 'bricks' ),
			'placeholderFormMessage'                      => esc_html__( 'Your message goes here. The more details, the better ;)', 'bricks' ),
			'placeholderImageInfo'                        => Helpers::article_link( 'filter-bricks-placeholder_image/', esc_html__( 'Placeholder image shown.', 'bricks' ) ),
			'placeholderTemplateName'                     => esc_html__( 'Enter new template name', 'bricks' ),
			'placeholderSearchDocumentation'              => esc_html__( 'Search documentation', 'bricks' ),
			'placeholderSelectPost'                       => esc_html__( 'Select post/page', 'bricks' ),
			'placeholderSelectLinkType'                   => esc_html__( 'Select link type', 'bricks' ),
			'placeholderYourName'                         => esc_html__( 'Your name (optional)', 'bricks' ),
			'playInteraction'                             => esc_html__( 'Play interaction', 'bricks' ),
			'playOnce'                                    => esc_html__( 'Play once', 'bricks' ),
			'popular'                                     => esc_html__( 'Popular', 'bricks' ),
			'popup'                                       => esc_html__( 'Popup', 'bricks' ),
			'position'                                    => esc_html__( 'Position', 'bricks' ),
			'post'                                        => esc_html__( 'Post', 'bricks' ),
			'posts'                                       => esc_html__( 'Posts', 'bricks' ),
			'postsOffsetDescription'                      => esc_html__( 'Ignored when posts per page set to "-1".', 'bricks' ),
			'postsPerPage'                                => esc_html__( 'Posts per page', 'bricks' ),
			'postType'                                    => esc_html__( 'Post type', 'bricks' ),
			'postTypes'                                   => esc_html__( 'Post types', 'bricks' ),
			// translators: %s: Link to Unsplash
			'poweredByUnsplash'                           => sprintf( esc_html__( 'Powered by %s', 'bricks' ), '<a href="https://unsplash.com/?ref=bricksbuilderio" target="_blank">Unsplash</a>' ),
			'prev'                                        => esc_html__( 'Prev', 'bricks' ),
			'preview'                                     => esc_html__( 'Preview', 'bricks' ),
			'prefix'                                      => esc_html__( 'Prefix', 'bricks' ),
			'previewMode'                                 => esc_html__( 'Preview mode', 'bricks' ),
			'previewTemplate'                             => esc_html__( 'Preview template', 'bricks' ),
			'property'                                    => esc_html__( 'Property', 'bricks' ),
			'propertyDefaultSelectControlInfo'            => esc_html__( 'To select a default value you have to first connect this property with the select control.', 'bricks' ),
			'propertyGroups'                              => esc_html__( 'Property groups', 'bricks' ),
			'propertyGroupsDesc'                          => esc_html__( 'Organize your properties in groups. Reorder your groups via drag & drop. Click to rename. Create a property group using the form below.', 'bricks' ),
			'propertyOptionsDesc'                         => esc_html__( 'Leave options empty to use the options of the first connected control.', 'bricks' ),
			'properties'                                  => esc_html__( 'Properties', 'bricks' ),
			'pseudoClass'                                 => esc_html__( 'Pseudo class', 'bricks' ),
			'pseudoClassError'                            => esc_html__( 'Invalid pseudo class. Must start with a colon (:)', 'bricks' ),
			'pseudos'                                     => esc_html__( 'Pseudos', 'bricks' ),
			'publish'                                     => esc_html__( 'Publish', 'bricks' ),
			'published'                                   => esc_html__( 'Published', 'bricks' ),

			'query'                                       => esc_html__( 'Query', 'bricks' ),
			'queryEditor'                                 => esc_html__( 'Query editor', 'bricks' ) . ' (PHP)',
			'queryEditorInfo'                             => sprintf(
				// translators: %s: Posts query link, %s: Terms query link, %s: Users query link
				esc_html__( 'Return query parameters in PHP array. Learn more about the query parameters for %1$s, %2$s, %3$s', 'bricks' ),
				'<a href="https://developer.wordpress.org/reference/classes/wp_query/#post-type-parameters" target="_blank">' . esc_html__( 'Posts', 'bricks' ) . '</a>',
				'<a href="https://developer.wordpress.org/reference/classes/wp_term_query/#source" target="_blank">' . esc_html__( 'Terms', 'bricks' ) . '</a>',
				'<a href="https://developer.wordpress.org/reference/classes/wp_user_query/#parameters" target="_blank">' . esc_html__( 'Users', 'bricks' ) . '</a>'
			),
			'queryEditorNoCodeExecutionInfo'              => esc_html__( 'Query editor in use. But not accessible due to lack of code execution rights.', 'bricks' ),
			'queryFilters'                                => esc_html__( 'Query filters', 'bricks' ),
			'queryLoop'                                   => esc_html__( 'Query loop', 'bricks' ),
			'queryMaxResultsInfo'                         => Builder::get_query_max_results_info(),

			'radius'                                      => esc_html__( 'Radius', 'bricks' ),
			'radial'                                      => esc_html__( 'Radial', 'bricks' ),
			'random'                                      => esc_html__( 'Random', 'bricks' ),
			'randomSeedTtl'                               => esc_html__( 'Random seed TTL', 'bricks' ),
			'randomSeedTtlDescription'                    => esc_html__( 'Time in minutes that the random seed will last. Avoid duplicate posts when using random order.', 'bricks' ),
			'raw'                                         => esc_html__( 'Raw', 'bricks' ),
			'redo'                                        => esc_html__( 'Redo', 'bricks' ),
			'relatedProducts'                             => esc_html__( 'Related products', 'bricks' ),
			'relatedProductsQueryDescription'             => esc_html__( 'Products with the same category or tag.', 'bricks' ),
			'reload'                                      => esc_html__( 'Reload', 'bricks' ),
			'reloadCanvas'                                => esc_html__( 'Reload canvas', 'bricks' ),
			'remote'                                      => esc_html__( 'Remote', 'bricks' ),
			'remoteTemplates'                             => esc_html__( 'Remote templates', 'bricks' ),
			'remove'                                      => esc_html__( 'Remove', 'bricks' ),
			'removed'                                     => esc_html__( 'Removed', 'bricks' ),
			'removeFile'                                  => esc_html__( 'Remove file', 'bricks' ),
			'removeFromIconSet'                           => esc_html__( 'Remove from icon set', 'bricks' ),
			'removeSelected'                              => esc_html__( 'Remove selected', 'bricks' ),
			'rename'                                      => esc_html__( 'Rename', 'bricks' ),
			'renamed'                                     => esc_html__( 'Renamed', 'bricks' ),
			'renameImages'                                => esc_html__( 'Rename images', 'bricks' ),
			'renameImagesDisabled'                        => esc_html__( 'Disabled: Keep original image filename.', 'bricks' ),
			'renameImagesEnabled'                         => esc_html__( 'Enabled: Rename image before download.', 'bricks' ),
			'richText'                                    => esc_html__( 'Rich Text', 'bricks' ),
			'linkRenderedAs'                              => esc_html__( 'Link rendered as', 'bricks' ),
			'repeat'                                      => esc_html__( 'Repeat', 'bricks' ),
			'relation'                                    => esc_html__( 'Relation', 'bricks' ),
			'restoreIcon'                                 => esc_html__( 'Restore icon', 'bricks' ),
			'replace'                                     => esc_html__( 'Replace', 'bricks' ),
			'replaceContent'                              => esc_html__( 'Replace content', 'bricks' ),
			'replaceContentDisabled'                      => esc_html__( 'Disabled: Insert below existing content.', 'bricks' ),
			'replaceContentEnabled'                       => esc_html__( 'Enabled: Replace existing content with template data.', 'bricks' ),
			'replaceWith'                                 => esc_html__( 'Replace with', 'bricks' ),
			'replaceElementClasses'                       => esc_html__( 'Replace element classes', 'bricks' ),
			'replaceElementClassesDesc'                   => esc_html__( 'Enable to replace global classes set on the element with the classes set on the property.', 'bricks' ),
			'replaceWithThisString'                       => esc_html__( 'Replace with this string', 'bricks' ),
			'responsiveBreakpoints'                       => esc_html__( 'Responsive breakpoints', 'bricks' ),
			'reset'                                       => esc_html__( 'Reset', 'bricks' ),
			'resetBreakpointsDescription'                 => esc_html__( 'Resetting all breakpoints deletes all custom breakpoints and resets all default breakpoints.', 'bricks' ),
			'restoreAll'                                  => esc_html__( 'Restore all', 'bricks' ),
			'resetStyles'                                 => esc_html__( 'Reset styles', 'bricks' ),
			'restore'                                     => esc_html__( 'Restore', 'bricks' ),
			'restored'                                    => esc_html__( 'Restored', 'bricks' ),
			'restoreSelected'                             => esc_html__( 'Restore selected', 'bricks' ),
			'resetDynamicData'                            => esc_html__( 'Clear non-existing dynamic data', 'bricks' ),
			'results'                                     => esc_html__( 'Results', 'bricks' ),
			'resultsFor'                                  => esc_html__( 'results for:', 'bricks' ),
			'reverse'                                     => esc_html__( 'Reverse', 'bricks' ),
			'revisionBy'                                  => esc_html__( 'Revision by', 'bricks' ),
			'revisionDeleted'                             => esc_html__( 'Revision deleted', 'bricks' ),
			'revisionApplied'                             => esc_html__( 'Revision applied', 'bricks' ),
			'revisionDiscarded'                           => esc_html__( 'Revision discarded', 'bricks' ),
			'revisions'                                   => esc_html__( 'Revisions', 'bricks' ),
			'revisionsDeleted'                            => esc_html__( 'All revisions deleted', 'bricks' ),
			'right'                                       => esc_html__( 'Right', 'bricks' ),
			'roles'                                       => esc_html__( 'Roles', 'bricks' ),
			'row'                                         => esc_html__( 'Row', 'bricks' ),
			'rows'                                        => esc_html__( 'Rows', 'bricks' ),

			'saturation'                                  => esc_html__( 'Saturation', 'bricks' ),
			'save'                                        => esc_html__( 'Save', 'bricks' ),
			'saveAs'                                      => esc_html__( 'Save as', 'bricks' ),
			'saveAsComponent'                             => esc_html__( 'Save as component', 'bricks' ),
			'saveDraft'                                   => esc_html__( 'Save draft', 'bricks' ),
			'saveAsTemplate'                              => esc_html__( 'Save as template', 'bricks' ),
			'saveNewStyle'                                => esc_html__( 'Save new style', 'bricks' ),
			'saveStyle'                                   => esc_html__( 'Save style', 'bricks' ),
			'saved'                                       => esc_html__( 'Saved', 'bricks' ),
			'savedAsTemplate'                             => esc_html__( 'Saved as template', 'bricks' ),
			'saveVariables'                               => esc_html__( 'Save Variables', 'bricks' ),
			'scale'                                       => esc_html__( 'Scale', 'bricks' ),
			'scanningSiteClassesInfo'                     => esc_html__( 'Scanning your entire site. This may take a moment.', 'bricks' ),
			'scope'                                       => esc_html__( 'Scope', 'bricks' ),
			'screenshotsGenerated'                        => esc_html__( 'Screenshots generated', 'bricks' ),
			'scroll'                                      => esc_html__( 'Scroll', 'bricks' ),
			'searchElements'                              => esc_html__( 'Search elements ..', 'bricks' ),
			'searchFor'                                   => esc_html__( 'Type to search for ..', 'bricks' ),
			'searchSettings'                              => esc_html__( 'Search settings', 'bricks' ),
			'search'                                      => esc_html__( 'Search', 'bricks' ),
			'searchPages'                                 => esc_html__( 'Search pages ..', 'bricks' ),
			'searchTemplates'                             => esc_html__( 'Search templates ..', 'bricks' ),
			'searchTag'                                   => esc_html__( 'Search tag', 'bricks' ),
			'searchVariable'                              => esc_html__( 'Search variable', 'bricks' ),
			'section'                                     => esc_html__( 'Section', 'bricks' ),
			'select'                                      => esc_html__( 'Select', 'bricks' ),
			'selectSvgIcons'                              => esc_html__( 'Select SVG Icons', 'bricks' ),
			'selector'                                    => esc_html__( 'Selector', 'bricks' ),
			'selectors'                                   => esc_html__( 'Selectors', 'bricks' ),
			'selectorExists'                              => esc_html__( 'Selector exists', 'bricks' ),
			'selection'                                   => esc_html__( 'Selection', 'bricks' ),
			'selectColorPalette'                          => esc_html__( 'Select color palette', 'bricks' ),
			'selectedClasses'                             => esc_html__( 'Selected classes', 'bricks' ),
			'selectedVariables'                           => esc_html__( 'Selected variables', 'bricks' ),
			'setTemplateConditions'                       => esc_html__( 'Set conditions', 'bricks' ),
			'selectFile'                                  => esc_html__( 'Select file', 'bricks' ),
			'selectFilesToImport'                         => esc_html__( 'Select file(s) to import', 'bricks' ),
			'selectIcon'                                  => esc_html__( 'Select icon', 'bricks' ),
			'selectImage'                                 => esc_html__( 'Select image', 'bricks' ),
			'selectIconSet'                               => esc_html__( 'Select icon set', 'bricks' ),
			'selectPostType'                              => esc_html__( 'Select post type', 'bricks' ),
			'selectPosts'                                 => esc_html__( 'Select posts', 'bricks' ),
			'selectTaxonomies'                            => esc_html__( 'Select taxonomies', 'bricks' ),
			'selectTemplate'                              => esc_html__( 'Select template', 'bricks' ),
			'selectTemplateTags'                          => esc_html__( 'Select template tags', 'bricks' ),
			'selectTemplateType'                          => esc_html__( 'Select template type', 'bricks' ),
			'selectTemplateToUpdate'                      => esc_html__( 'Select template to update', 'bricks' ),
			'selectTerms'                                 => esc_html__( 'Select terms', 'bricks' ),
			'selectTerm'                                  => esc_html__( 'Select term', 'bricks' ),
			'selectedElements'                            => esc_html__( 'Selected elements', 'bricks' ),
			'selectorDetector'                            => esc_html__( 'Selector detector', 'bricks' ),
			'selectorDetectorEmpty'                       => esc_html__( 'Select the node that you want to style inside the currently active element on the canvas.', 'bricks' ),
			'selectorDetectorInfo'                        => esc_html__( 'Construct the selector you want to create from the node tree below by toggling the relevant selectors.', 'bricks' ),
			'send'                                        => esc_html__( 'Send', 'bricks' ),
			'sepia'                                       => esc_html__( 'Sepia', 'bricks' ),
			'settings'                                    => esc_html__( 'Settings', 'bricks' ),
			'settingsImported'                            => esc_html__( 'Settings imported', 'bricks' ),
			'settingsResetted'                            => esc_html__( 'Settings resetted', 'bricks' ),
			'solid'                                       => esc_html__( 'Solid', 'bricks' ),
			'sort'                                        => esc_html__( 'Sort', 'bricks' ),
			'settings'                                    => esc_html__( 'Settings', 'bricks' ),
			'shape'                                       => esc_html__( 'Shape', 'bricks' ),
			'shapeDividers'                               => esc_html__( 'Shape dividers', 'bricks' ),
			'shortcuts'                                   => esc_html__( 'Shortcuts', 'bricks' ),
			'showAuthor'                                  => esc_html__( 'Show author', 'bricks' ),
			'show'                                        => esc_html__( 'Show', 'bricks' ),
			'showDate'                                    => esc_html__( 'Show date', 'bricks' ),
			'showEmpty'                                   => esc_html__( 'Show empty', 'bricks' ),
			'showElement'                                 => esc_html__( 'Show element', 'bricks' ),
			'showExcerpt'                                 => '<a href="https://codex.wordpress.org/Excerpt" target="_blank">' . esc_html__( 'Show excerpt', 'bricks' ) . '</a>',
			'showInfo'                                    => esc_html__( 'Show info', 'bricks' ),
			'showFullscreen'                              => esc_html__( 'Show fullscreen', 'bricks' ),
			'showTitle'                                   => esc_html__( 'Show title', 'bricks' ),
			'signAll'                                     => esc_html__( 'Sign all', 'bricks' ),
			'signCode'                                    => esc_html__( 'Sign code', 'bricks' ),
			'single'                                      => esc_html__( 'Single', 'bricks' ),
			'site'                                        => esc_html__( 'Site', 'bricks' ),
			'size'                                        => esc_html__( 'Size', 'bricks' ),
			'skip'                                        => esc_html__( 'Skip', 'bricks' ),
			'slide'                                       => esc_html__( 'Slide', 'bricks' ),
			'slider-nested'                               => esc_html__( 'Slide', 'bricks' ), // ActionAdd.vue tooltip
			'small'                                       => esc_html__( 'Small', 'bricks' ),
			'source'                                      => esc_html__( 'Source', 'bricks' ),
			'spaceBetween'                                => esc_html__( 'Space between', 'bricks' ),
			'spaceAround'                                 => esc_html__( 'Space around', 'bricks' ),
			'spaceEvenly'                                 => esc_html__( 'Space evenly', 'bricks' ),
			'spread'                                      => esc_html__( 'Spread', 'bricks' ),
			'square'                                      => esc_html__( 'Square', 'bricks' ),
			'start'                                       => esc_html__( 'Start', 'bricks' ),
			'startingAngle'                               => esc_html__( 'Starting angle in º', 'bricks' ),
			'startPlayAt'                                 => esc_html__( 'Start play at', 'bricks' ),
			'startTime'                                   => esc_html__( 'Start time', 'bricks' ),
			'stretch'                                     => esc_html__( 'Stretch', 'bricks' ),
			'strike'                                      => esc_html__( 'Strike', 'bricks' ),
			'strikethrough'                               => esc_html__( 'Strikethrough', 'bricks' ),
			'strokeColor'                                 => esc_html__( 'Stroke color', 'bricks' ),
			'strokeWidth'                                 => esc_html__( 'Stroke width', 'bricks' ),
			'structure'                                   => esc_html__( 'Structure', 'bricks' ),
			'style'                                       => esc_html__( 'Style', 'bricks' ),
			'styles'                                      => esc_html__( 'Styles', 'bricks' ),
			'subject'                                     => esc_html__( 'Subject', 'bricks' ),
			'suffix'                                      => esc_html__( 'Suffix', 'bricks' ),
			'sure'                                        => esc_html__( 'Sure?', 'bricks' ),
			'switch'                                      => esc_html__( 'Switch', 'bricks' ),
			'svgUploadNotAllowed'                         => esc_html__( 'You are not allowed to uploads SVG files.', 'bricks' ),

			'tablet'                                      => esc_html__( 'Tablet', 'bricks' ),
			'tag'                                         => esc_html__( 'Tag', 'bricks' ),
			'taxonomy'                                    => esc_html__( 'Taxonomy', 'bricks' ),
			'taxonomies'                                  => esc_html__( 'Taxonomies', 'bricks' ),
			'taxQuery'                                    => esc_html__( 'Taxonomy query', 'bricks' ),
			'template'                                    => esc_html__( 'Template', 'bricks' ),
			'templateBundle'                              => esc_html__( 'Template bundle', 'bricks' ),
			'templateCreated'                             => esc_html__( 'Template created', 'bricks' ),
			'templateDeleted'                             => esc_html__( 'Template deleted', 'bricks' ),
			'templateImportHint'                          => esc_html__( 'Inserting any template overwrites your data. We recommend to save your changes first.', 'bricks' ),
			'templateImported'                            => esc_html__( 'Template imported', 'bricks' ),
			'templateInserted'                            => esc_html__( 'Template inserted', 'bricks' ),
			'templateInsertErrorNoData'                   => esc_html__( 'Template insert failed: This template has no data', 'bricks' ),
			'templateOverridden'                          => esc_html__( 'Template overridden', 'bricks' ),
			'templateReleaseSinceCancellation'            => esc_html__( 'new templates have been released since you cancelled Bricks.', 'bricks' ),
			'templateSaved'                               => esc_html__( 'Template saved', 'bricks' ),
			'templateSettings'                            => esc_html__( 'Template settings', 'bricks' ),
			'templateTag'                                 => esc_html__( 'Template tag', 'bricks' ),
			'templateTags'                                => esc_html__( 'Template tags', 'bricks' ),
			'templateType'                                => esc_html__( 'Template type', 'bricks' ),
			'templateTypeDescription'                     => esc_html__( 'Select the type of template you want to create:', 'bricks' ),
			'templates'                                   => esc_html__( 'Templates', 'bricks' ),
			'terms'                                       => esc_html__( 'Terms', 'bricks' ),
			'term'                                        => esc_html__( 'Term', 'bricks' ),
			'text'                                        => esc_html__( 'Text', 'bricks' ),
			'textAlign'                                   => esc_html__( 'Text align', 'bricks' ),
			'textArea'                                    => esc_html__( 'Textarea', 'bricks' ),
			'textDecoration'                              => esc_html__( 'Text decoration', 'bricks' ),
			'textShadow'                                  => esc_html__( 'Text shadow', 'bricks' ),
			'textTransform'                               => esc_html__( 'Text transform', 'bricks' ),
			'textWrap'                                    => esc_html__( 'Text wrap', 'bricks' ),
			'themeStyle'                                  => esc_html__( 'Theme Style', 'bricks' ),
			'themeStyles'                                 => esc_html__( 'Theme Styles', 'bricks' ),
			'themeStyleInfoLoadAll'                       => '<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">' . esc_html__( 'Currently all matching theme styles are loaded. To load only the most specific theme style, adjust your settings under "Theme styles: Loading method".', 'bricks' ) . '</a>',
			'themeStyleInfoLoadSpecific'                  => '<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">' . esc_html__( 'Currently only the most specific theme style is loaded. To load all matching theme styles, adjust your settings under "Theme styles: Loading method".', 'bricks' ) . '</a>',
			'themeStyleActiveInfo'                        => esc_html__( 'Set condition(s) to apply selected theme style to your entire website or certain areas.', 'bricks' ),
			'themeStyleNameExists'                        => esc_html__( 'The style name entered already exists. Please choose a different name.', 'bricks' ),
			// translators: %s: Theme Styles link
			'themeStyleSelectInfo'                        => sprintf( esc_html__( 'Select a theme style or create a new one to style your website (%s).', 'bricks' ), Helpers::article_link( 'theme-styles', esc_html__( 'learn more', 'bricks' ) ) ),
			'themeStyleCreated'                           => esc_html__( 'Theme style created', 'bricks' ),
			'themeStyleDeleted'                           => esc_html__( 'Theme style deleted', 'bricks' ),
			'themeStyleNewName'                           => esc_html__( 'New theme style name', 'bricks' ),
			'themeStyleSaved'                             => esc_html__( 'Style saved', 'bricks' ),
			'title'                                       => esc_html__( 'Title', 'bricks' ),
			'toggle'                                      => esc_html__( 'Toggle', 'bricks' ),
			'top'                                         => esc_html__( 'Top', 'bricks' ),
			'topLeft'                                     => esc_html__( 'Top left', 'bricks' ),
			'topCenter'                                   => esc_html__( 'Top center', 'bricks' ),
			'topRight'                                    => esc_html__( 'Top right', 'bricks' ),
			'thumbnail'                                   => esc_html__( 'Thumbnail', 'bricks' ),
			'true'                                        => esc_html__( 'True', 'bricks' ),
			'type'                                        => esc_html__( 'Type', 'bricks' ),
			'typography'                                  => esc_html__( 'Typography', 'bricks' ),
			'transform'                                   => [
				'transform'  => esc_html__( 'Transform', 'bricks' ),
				'translateX' => esc_html__( 'Translate X', 'bricks' ),
				'translateY' => esc_html__( 'Translate Y', 'bricks' ),

				'scaleX'     => esc_html__( 'Scale X', 'bricks' ),
				'scaleY'     => esc_html__( 'Scale Y', 'bricks' ),

				'rotateX'    => esc_html__( 'Rotate X', 'bricks' ),
				'rotateY'    => esc_html__( 'Rotate Y', 'bricks' ),
				'rotateZ'    => esc_html__( 'Rotate Z', 'bricks' ),

				'skewX'      => esc_html__( 'Skew X', 'bricks' ),
				'skewY'      => esc_html__( 'Skew Y', 'bricks' ),
			],
			'trash'                                       => esc_html__( 'Trash', 'bricks' ),
			'trashEmpty'                                  => esc_html__( 'Trash is empty', 'bricks' ),

			'unconnected'                                 => esc_html__( 'Unconnected', 'bricks' ),
			'unconnectedPropertiesDescription'            => esc_html__( 'Unconnected properties detected. Edit your component or any of its children to connect your properties to a specific setting.', 'bricks' ),
			'underline'                                   => esc_html__( 'Underline', 'bricks' ),
			'undo'                                        => esc_html__( 'Undo', 'bricks' ),
			'unlink'                                      => esc_html__( 'Unlink', 'bricks' ),
			'unlinked'                                    => esc_html__( 'Unlinked', 'bricks' ),
			'unlinkComponent'                             => esc_html__( 'Unlink component', 'bricks' ),
			'unlinkComponentConfirm'                      => esc_html__( 'Are you sure you want to unlink this component?', 'bricks' ),
			'unlock'                                      => esc_html__( 'Unlock', 'bricks' ),
			'unlocked'                                    => esc_html__( 'Unlocked', 'bricks' ),
			'unsplashErrorInvalidApiKey'                  => esc_html__( 'Your Unsplash API key is not valid.', 'bricks' ),
			'unsplashErrorNoApiKey'                       => sprintf(
				// translators: %s: API keys link
				esc_html__( 'Unsplash API key required! Add key in dashboard under: %s', 'bricks' ),
				'<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" target="_blank">Bricks > ' . esc_html__( 'Settings', 'bricks' ) . ' > API keys</a>'
			),
			'unsplashErrorRateLimitReached'               => esc_html__( 'Rate limit for this hour reached. Please wait until the next full hour for it to be resetted.', 'bricks' ),
			'unsplashSearchPlaceholder'                   => esc_html__( 'Type keyword, hit enter.', 'bricks' ),

			'uncategorized'                               => esc_html__( 'Uncategorized', 'bricks' ),
			'understandingTheLayout'                      => esc_html__( 'Understanding the layout', 'bricks' ),
			'unitTooltip'                                 => esc_html__( 'Select/enter unit', 'bricks' ),
			'unpin'                                       => esc_html__( 'Unpin', 'bricks' ),
			'unpinned'                                    => esc_html__( 'Unpinned', 'bricks' ),
			'unsignedCode'                                => esc_html__( 'Unsigned code', 'bricks' ),
			'unsplashSetApiKey'                           => '<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" class="button" target="_blank">' . esc_html__( 'Set Unsplash API Key', 'bricks' ) . '</a>',
			'unusedOnThisPage'                            => esc_html__( 'Unused on this page', 'bricks' ),
			'unusedOnThisSite'                            => esc_html__( 'Unused on this site', 'bricks' ),
			'unwrap'                                      => esc_html__( 'Unwrap', 'bricks' ),
			'update'                                      => esc_html__( 'Update', 'bricks' ),
			'updatingVariableReferences'                  => esc_html__( 'Updating references to %s global variable(s) across the entire site...', 'bricks' ),
			'updated'                                     => esc_html__( 'Updated', 'bricks' ),
			'upload'                                      => esc_html__( 'Upload', 'bricks' ),
			'uppercase'                                   => esc_html__( 'Uppercase', 'bricks' ),
			'upSells'                                     => esc_html__( 'Upsells', 'bricks' ),
			'upSellsQueryDescription'                     => esc_html__( 'Place this query on the single product page.', 'bricks' ),
			'uploadSvg'                                   => esc_html__( 'Upload SVG', 'bricks' ),
			'url'                                         => esc_html__( 'URL', 'bricks' ),
			'urlParameters'                               => esc_html__( 'URL parameters', 'bricks' ),
			'usedOnThisPage'                              => esc_html__( 'Used on this page', 'bricks' ),
			'usedOnThisSite'                              => esc_html__( 'Used on this site', 'bricks' ),
			'useMinMax'                                   => esc_html__( 'Use min/max', 'bricks' ),
			'useMinMaxDescription'                        => sprintf( esc_html__( 'Use %s when adding columns/rows', 'bricks' ), 'minmax(0, 1fr)' ),
			'userProfile'                                 => esc_html__( 'User profile', 'bricks' ),

			'value'                                       => esc_html__( 'Value', 'bricks' ),
			'variableNameExists'                          => esc_html__( 'Variable name already exists', 'bricks' ),
			'variable'                                    => esc_html__( 'Variable', 'bricks' ),
			'variables'                                   => esc_html__( 'Variables', 'bricks' ),
			'variablesDuplicated'                         => esc_html__( 'Variables duplicated', 'bricks' ),
			'variablesImported'                           => esc_html__( 'Variables imported', 'bricks' ),
			'variablesRenamed'                            => esc_html__( 'Variables renamed', 'bricks' ),
			'variableCategoriesImportConfirm'             => esc_html__( 'Would you like to import the variable categories as well?', 'bricks' ),
			'variableName'                                => esc_html__( 'Variable name', 'bricks' ),
			'variableNamePlaceholder'                     => esc_html__( 'New variable name', 'bricks' ),
			'variableNewNoName'                           => esc_html__( 'Variable name missing', 'bricks' ),
			'variableNewAlreadyExists'                    => esc_html__( 'Variable name already exists', 'bricks' ),
			'vertical'                                    => esc_html__( 'Vertical', 'bricks' ),
			'verticalAlignment'                           => esc_html__( 'Vertical alignment', 'bricks' ),
			'video'                                       => esc_html__( 'Video', 'bricks' ),
			'videoUrl'                                    => esc_html__( 'Video URL', 'bricks' ),
			'view'                                        => esc_html__( 'View', 'bricks' ),
			'viewClasses'                                 => esc_html__( 'View classes', 'bricks' ),
			'viewOnFrontend'                              => esc_html__( 'View on frontend', 'bricks' ),
			'visible'                                     => esc_html__( 'Visible', 'bricks' ),
			'visibility'                                  => esc_html__( 'Visibility', 'bricks' ),
			'visitDocs'                                   => esc_html__( 'Visit docs', 'bricks' ),
			'visualGridBuilder'                           => esc_html__( 'Visual grid builder', 'bricks' ),

			'whiteSpace'                                  => esc_html__( 'White space', 'bricks' ),
			'width'                                       => esc_html__( 'Width', 'bricks' ),
			'willOverrideLocal'                           => esc_html__( 'Will override local', 'bricks' ),
			'woocommerce_product'                         => esc_html__( 'Product', 'bricks' ),
			'wordpress'                                   => 'WordPress',
			'wrap'                                        => esc_html__( 'Wrap', 'bricks' ),
			'nowrap'                                      => esc_html__( 'No wrap', 'bricks' ),
			'wrap-reverse'                                => esc_html__( 'Wrap reverse', 'bricks' ),

			'xAxis'                                       => esc_html__( 'X axis', 'bricks' ),
			'yAxis'                                       => esc_html__( 'Y axis', 'bricks' ),

			'yes'                                         => esc_html__( 'Yes', 'bricks' ),
			'you'                                         => esc_html__( 'You', 'bricks' ),
			'youAreMissingOut'                            => esc_html__( 'You are missing out!', 'bricks' ),

			'zIndex'                                      => esc_html__( 'Z-index', 'bricks' ),
			'zoom'                                        => esc_html__( 'Zoom', 'bricks' ),
			'errorCreatingFont'                           => esc_html__( 'Failed to create font', 'bricks' ),
			'errorMovingFontToTrash'                      => esc_html__( 'Failed to move font to trash.', 'bricks' ),
			'errorDeletingFont'                           => esc_html__( 'Failed to delete font', 'bricks' ),
			'errorProcessingFontFiles'                    => esc_html__( 'Error processing font files', 'bricks' ),
			'errorUploadingFont'                          => esc_html__( 'Error uploading font', 'bricks' ),
			'invalidFontFile'                             => esc_html__( 'Invalid font file', 'bricks' ),
			'removeFromFavorites'                         => esc_html__( 'Remove from favorites', 'bricks' ),
			'selectFontFile'                              => esc_html__( 'Select font file', 'bricks' ),
		];
	}

	public static function get_all_i18n() {
		$admin_i18n            = self::get_admin_i18n();
		$builder_i18n          = self::get_builder_i18n();
		$frontend_translations = self::get_frontend_i18n();

		// Merge admin translations into builder and frontend translations.
		$all_translations = array_merge( $admin_i18n, $builder_i18n, $frontend_translations );

		return $all_translations;
	}
}
